/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.QueuedArchive;

public class DBArchive
extends QueuedArchive {
    public static final long DEFAULT_TIME_INTERVAL = 1000L;
    public static final long DEFAULT_COUNT_INTERVAL = 1L;
    private Connection conn;
    private PreparedStatement stmt = null;
    private long commitTimeInterval = 1000L;
    private long commitCountInterval = 1L;
    private long commitCount = 0L;
    private Thread commitTimer;
    private static Logger logger = Logger.getLogger("org.jini.rio.watch");
    private String driver;
    private String database;
    private String tableName;

    public DBArchive(Connection conn, String tableName) throws SQLException {
        this.conn = conn;
        this.stmt = conn.prepareStatement("insert into " + tableName + " values(?, ?)");
        CommitTimer timer = new CommitTimer();
        timer.start();
    }

    public DBArchive(Connection conn, PreparedStatement stmt) {
        this.conn = conn;
        this.stmt = stmt;
        CommitTimer timer = new CommitTimer();
        timer.start();
    }

    protected void addParameters(Calculable calculable, PreparedStatement stmt) throws SQLException, IOException {
        if (stmt == null) {
            throw new IOException("PreparedStatement is null in DBArchive");
        }
        stmt.setString(1, calculable.getId());
        stmt.setDouble(2, calculable.getValue());
    }

    @Override
    public void archiveToResource(Calculable calculable) throws IOException {
        if (this.stmt == null) {
            throw new IOException("PreparedStatement is null in DBArchive");
        }
        try {
            this.stmt.clearParameters();
            this.addParameters(calculable, this.stmt);
            this.stmt.executeUpdate();
            ++this.commitCount;
            this.commit(this.commitCountInterval);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void closeResource() {
        try {
            this.stmt.close();
        }
        catch (SQLException ex) {
            logger.log(Level.WARNING, "Closing SQL Statement", ex);
        }
        this.stmt = null;
        this.commit(1L);
        if (this.commitTimer != null) {
            this.commitTimer.interrupt();
        }
    }

    private synchronized void commit(long commitCountInterval) {
        if (this.commitCount >= commitCountInterval) {
            try {
                this.conn.commit();
                this.commitCount = 0L;
            }
            catch (SQLException ex) {
                logger.log(Level.WARNING, "Committing inserts", ex);
            }
        }
    }

    public long getCommitTimeInterval() {
        return this.commitTimeInterval;
    }

    public void setCommitTimeInterval(long commitTimeInterval) {
        this.commitTimeInterval = commitTimeInterval;
    }

    public long getCommitCountInterval() {
        return this.commitCountInterval;
    }

    public void setCommitCountInterval(long commitCountInterval) {
        this.commitCountInterval = commitCountInterval;
    }

    public void initialize() throws IOException {
        try {
            Class.forName(this.driver).newInstance();
            this.conn = DriverManager.getConnection(this.database);
            this.stmt = this.conn.prepareStatement("insert into " + this.tableName + " values(?, ?)");
            CommitTimer timer = new CommitTimer();
            timer.start();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Initializing DB Archive", ex);
            throw new IOException(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        String driver = "COM.cloudscape.core.JDBCDriver";
        String protocol = "jdbc:cloudscape:";
        String db = "archivalTestDB";
        try {
            Class.forName(driver).newInstance();
            System.out.println("Loaded JDBC Driver: " + driver);
            Connection conn = DriverManager.getConnection(protocol + db + ";create=true");
            System.out.println("Connected to and created database " + db);
            conn.setAutoCommit(false);
            Statement s = conn.createStatement();
            s.execute("create table archive(id varchar(40), value numeric(10,3))");
            conn.commit();
            System.out.println("Created table: archive");
            s.close();
            DBArchive arch = new DBArchive(conn, "archive");
            arch.setCommitCountInterval(20L);
            for (double v = 0.0; v < 100.0; v += 1.5) {
                arch.archive(new Calculable("test", v));
            }
            arch.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    class CommitTimer
    extends Thread {
        public CommitTimer() {
            this.setDaemon(true);
            this.setName(this.getClass().getName() + ":CommitTimer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DBArchive.this.commitTimer = Thread.currentThread();
            while (!DBArchive.this.commitTimer.isInterrupted()) {
                CommitTimer commitTimer = this;
                synchronized (commitTimer) {
                    try {
                        this.wait(DBArchive.this.commitTimeInterval);
                        DBArchive.this.commit(1L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            DBArchive.this.commit(1L);
        }
    }
}

