/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.watch.Accumulator;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.CalculableDisplayAttributes;
import org.jini.rio.watch.CalculableViewable;
import org.jini.rio.watch.FontDescriptor;
import org.jini.rio.watch.WatchDataSource;

public class DefaultCalculableView
implements CalculableViewable {
    protected static final int TOP_AXIS_MARGIN = 20;
    protected static final int BOTTOM_AXIS_MARGIN = 20;
    protected static final int LEFT_AXIS_MARGIN = 50;
    protected static final int RIGHT_AXIS_MARGIN = 35;
    protected static final int TOP_GRAPH_MARGIN = 40;
    protected static final int BOTTOM_GRAPH_MARGIN = 21;
    protected static final int LEFT_GRAPH_MARGIN = 51;
    protected static final int RIGHT_GRAPH_MARGIN = 45;
    protected static final int VERTICAL_GRAPH_OFFSET = 10;
    protected static final int TOTAL_H_GRAPH_MARGIN = 96;
    protected static final int TOTAL_V_GRAPH_MARGIN = 61;
    protected static final int VERTICAL__MIN_GRID_HEIGHT = 15;
    protected static final int HORIZONTAL__MIN_GRID_WIDTH = 40;
    protected static final Color devColor = new Color(204, 0, 204);
    protected static final Color avgColor = new Color(68, 187, 121);
    public static final DecimalFormat defaultFormater = new DecimalFormat("#0.0");
    protected static final Font defaultFont = new Font("Dialog", 0, 10);
    protected static final CalculableDisplayAttributes defaultDisplayAttributes = new CalculableDisplayAttributes("Value", new FontDescriptor("Dialog", 0, 10), 0, new DecimalFormat("#,##0.###"), "Events", new FontDescriptor("Dialog", 0, 10), 0, new DecimalFormat("#,##0.###"), "Measurement", new FontDescriptor("Dialog", 1, 12), Calculable.class);
    protected WatchDataSource watchDataSource;
    protected Accumulator accum;
    protected Calculable[] data = null;
    protected double highThreshold = Double.NaN;
    protected double lowThreshold = Double.NaN;
    protected double startRange = 0.0;
    protected double stopRange = 0.0;
    protected double startValue = 0.0;
    protected double stopValue = 0.0;
    protected double min = 0.0;
    protected double max = 0.0;
    protected double mean = 0.0;
    protected double stdDev = 0.0;
    protected String yLegend = "";
    protected Font yLegendFont = defaultFont;
    protected double yScale = 0.0;
    protected NumberFormat yFormat = defaultFormater;
    protected String xLegend = "";
    protected Font xLegendFont = defaultFont;
    protected double xScale = 0.0;
    protected NumberFormat xFormat = defaultFormater;
    protected String title = "";
    protected Font titleFont = defaultFont;
    protected CalculableDisplayAttributes calcDisplayAttrs;
    protected int currentSize = 0;
    protected int offset = 0;
    protected double drawWidth = 0.0;
    protected double rangeSize = 0.0;
    protected double drawHeight = 0.0;
    protected double topLineValue = 0.0;
    protected double bottomLineValue = 0.0;
    protected double valuesRange = 0.0;
    protected double vStep = 0.0;
    protected double vStepMultiplier = 1.0;
    protected double nbrHGrids = 0.0;
    protected double maxY = 0.0;
    protected double minY = 0.0;

    public DefaultCalculableView() {
        this(defaultDisplayAttributes);
    }

    public DefaultCalculableView(CalculableDisplayAttributes calcDisplayAttrs) {
        this.setCalculableDisplayAttributes(calcDisplayAttrs);
    }

    public void setCalculableDisplayAttributes(CalculableDisplayAttributes calcDisplayAttrs) {
        this.calcDisplayAttrs = calcDisplayAttrs;
    }

    @Override
    public void setWatchDataSource(WatchDataSource watchDataSource) {
        this.resetValues();
        this.watchDataSource = watchDataSource;
        this.initValues();
    }

    protected void resetValues() {
        this.watchDataSource = null;
        this.data = null;
        this.highThreshold = Double.NaN;
        this.lowThreshold = Double.NaN;
        this.startRange = 0.0;
        this.startValue = 0.0;
        this.stopRange = 0.0;
        this.stopValue = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        this.mean = 0.0;
        this.stdDev = 0.0;
        this.yLegend = "";
        this.yLegendFont = defaultFont;
        this.yScale = 0.0;
        this.yFormat = defaultFormater;
        this.xLegend = "";
        this.xLegendFont = defaultFont;
        this.xScale = 0.0;
        this.xFormat = defaultFormater;
        this.title = "";
        this.titleFont = defaultFont;
        this.currentSize = 0;
        this.offset = 0;
    }

    protected void initValues() {
        try {
            this.currentSize = this.watchDataSource.getCurrentSize();
            this.offset = this.watchDataSource.getOffset();
            ThresholdValues tvalues = this.watchDataSource.getThresholdValues();
            this.highThreshold = tvalues.getHighThreshold();
            this.lowThreshold = tvalues.getLowThreshold();
            this.accum = new Accumulator(this.watchDataSource);
            this.accum.init(this.offset, this.currentSize);
            this.data = this.accum.getCalcs();
            this.yLegend = this.calcDisplayAttrs.getYLegend();
            FontDescriptor fd = this.calcDisplayAttrs.getYLegendFont();
            this.yLegendFont = new Font(fd.getName(), fd.getStyle(), fd.getSize());
            this.yScale = Math.pow(10.0, this.calcDisplayAttrs.getYScale());
            this.yFormat = this.calcDisplayAttrs.getYFormat();
            this.xLegend = this.calcDisplayAttrs.getXLegend();
            fd = this.calcDisplayAttrs.getXLegendFont();
            this.xLegendFont = new Font(fd.getName(), fd.getStyle(), fd.getSize());
            this.xScale = Math.pow(10.0, this.calcDisplayAttrs.getXScale());
            this.xFormat = this.calcDisplayAttrs.getXFormat();
            this.title = this.calcDisplayAttrs.getTitle();
            fd = this.calcDisplayAttrs.getTitleFont();
            this.titleFont = new Font(fd.getName(), fd.getStyle(), fd.getSize());
            this.min = this.accum.min() / this.yScale;
            this.max = this.accum.max() / this.yScale;
            this.mean = this.accum.mean() / this.yScale;
            this.stdDev = this.accum.standardDeviation() / this.yScale;
            if (!Double.isNaN(this.highThreshold)) {
                this.highThreshold /= this.yScale;
            }
            if (!Double.isNaN(this.lowThreshold)) {
                this.lowThreshold /= this.yScale;
            }
            this.startRange = this.watchDataSource.getOffset();
            this.startValue = 0.0;
            this.stopRange = this.watchDataSource.getOffset() + this.data.length - 1;
            this.stopValue = this.data.length - 1;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g, Dimension size) {
        try {
            int pY;
            double y;
            int pY2;
            double vGridStart;
            double i;
            g.setColor(new Color(232, 232, 232));
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(Color.black);
            g.drawLine(50, 20, 50, size.height - 20);
            g.drawLine(50, size.height - 20, size.width - 35, size.height - 20);
            g.setFont(this.yLegendFont);
            g.drawString(this.yLegend, 45, 15);
            g.setFont(this.xLegendFont);
            g.drawString(this.xLegend, size.width - 30, size.height - 15);
            g.setFont(this.titleFont);
            g.drawString(this.title, 371, 20);
            if (this.data == null || this.data.length == 0) {
                return;
            }
            g.setFont(defaultFont);
            g.drawString("min=" + this.yFormat.format(this.min), 101, 10);
            g.drawString("max=" + this.yFormat.format(this.max), 101, 20);
            g.drawString("stdDev=" + this.yFormat.format(this.stdDev), 181, 10);
            g.drawString("mean=" + this.yFormat.format(this.mean), 181, 20);
            if (!Double.isNaN(this.highThreshold)) {
                g.drawString("highThreshold=" + this.yFormat.format(this.highThreshold), 261, 10);
            }
            if (!Double.isNaN(this.lowThreshold)) {
                g.drawString("lowThreshold=" + this.yFormat.format(this.lowThreshold), 261, 20);
            }
            this.drawWidth = size.width - 96;
            this.drawHeight = size.height - 61 - 10;
            this.topLineValue = this.getTopLineValue();
            this.bottomLineValue = this.getBottomLineValue();
            if (this.bottomLineValue == this.topLineValue) {
                if (this.bottomLineValue == 0.0) {
                    this.topLineValue = 1.0;
                } else {
                    this.bottomLineValue = 0.0;
                }
            }
            this.valuesRange = this.topLineValue - this.bottomLineValue;
            this.vStep = this.drawHeight / this.valuesRange;
            this.vStepMultiplier = 1.0;
            while (this.vStep * this.vStepMultiplier < 15.0) {
                this.vStepMultiplier += 1.0;
            }
            this.nbrHGrids = this.valuesRange / this.vStepMultiplier + 1.0;
            this.maxY = this.drawHeight - this.vStep * this.valuesRange + 40.0;
            this.minY = this.drawHeight + 40.0;
            double stopValue = this.stopValue;
            double startValue = this.startValue;
            if (stopValue == startValue) {
                stopValue += 1.0;
            }
            this.rangeSize = stopValue - startValue;
            double divider = 1.0;
            while (this.drawWidth / (this.rangeSize / divider) < 40.0) {
                divider += 1.0;
            }
            double nbrVLabels = this.rangeSize / divider;
            double xLabelsStep = this.drawWidth / nbrVLabels;
            double xLabelValIncrement = this.rangeSize / nbrVLabels;
            g.setColor(Color.lightGray);
            for (i = 1.0; i <= nbrVLabels; i += 1.0) {
                int x = (int)(50.0 + i * xLabelsStep);
                g.drawLine(x, 30, x, size.height - 21);
            }
            g.setFont(this.xLegendFont);
            g.setColor(Color.black);
            i = 0.0;
            double lValue = startValue;
            while (i <= nbrVLabels) {
                g.drawString(String.valueOf((int)lValue + 1), (int)(45.0 + i * xLabelsStep), size.height - 10);
                i += 1.0;
                lValue += xLabelValIncrement;
            }
            g.setFont(this.yLegendFont);
            FontMetrics fm = g.getFontMetrics();
            double lValue2 = vGridStart = (double)((int)(this.topLineValue / this.vStepMultiplier)) * this.vStepMultiplier;
            int i2 = 0;
            while ((double)i2 < this.nbrHGrids && (pY2 = (int)(this.minY - this.vStep * ((y = vGridStart - (double)i2 * this.vStepMultiplier) - this.bottomLineValue))) < size.height - 20) {
                g.setColor(Color.lightGray);
                g.drawLine(51, pY2, size.width - 35, pY2);
                g.setColor(Color.black);
                String fmtVal = this.yFormat.format(lValue2);
                g.drawString(fmtVal, 48 - fm.stringWidth(fmtVal), pY2 + 3);
                ++i2;
                lValue2 -= this.vStepMultiplier;
            }
            if (!Double.isNaN(this.highThreshold)) {
                g.setColor(Color.red);
                pY = (int)(this.minY - this.vStep * (this.highThreshold - this.bottomLineValue));
                g.drawLine(51, pY, size.width - 35, pY);
                g.drawLine(51, pY + 1, size.width - 35, pY + 1);
            }
            if (!Double.isNaN(this.lowThreshold)) {
                g.setColor(Color.orange);
                pY = (int)(this.minY - this.vStep * (this.lowThreshold - this.bottomLineValue));
                g.drawLine(51, pY, size.width - 35, pY);
                g.drawLine(51, pY + 1, size.width - 35, pY + 1);
            }
            if (this.stdDev > 0.0) {
                g.setColor(avgColor);
                pY = (int)(this.minY - this.vStep * (this.mean - this.bottomLineValue));
                g.drawLine(51, pY, size.width - 35, pY);
                g.drawString("mean", size.width - 30, pY + 2);
            }
            if (!Double.isNaN(this.stdDev) && this.stdDev > 0.0) {
                int uY = (int)(this.minY - this.vStep * (this.mean + this.stdDev - this.bottomLineValue));
                int dY = (int)(this.minY - this.vStep * (this.mean - this.stdDev - this.bottomLineValue));
                g.setColor(devColor);
                int len = size.width - 35;
                for (int x = 51; x < len; x += 10) {
                    g.drawLine(x, uY, x + 5, uY);
                    g.drawLine(x, dY, x + 5, dY);
                }
                g.drawString("dev", size.width - 30, uY + 2);
                g.drawString("dev", size.width - 30, dY + 2);
            }
            double hStep = this.drawWidth / this.rangeSize;
            double idxJump = 1.0;
            if (hStep == 0.0) {
                hStep = 1.0;
                idxJump = this.rangeSize / this.drawWidth;
            }
            double dataIdx = 0.0;
            dataIdx = startValue == 0.0 ? 0.0 : (startValue < (double)(this.watchDataSource.getOffset() - 1) ? startValue : startValue - (double)(this.watchDataSource.getOffset() - 1));
            g.setColor(Color.blue);
            int len = this.getLength();
            if (len == 1 && dataIdx < (double)len) {
                double y2 = this.data[(int)dataIdx].getValue() / this.yScale;
                int pY3 = (int)(this.minY - this.vStep * (y2 - this.bottomLineValue));
                g.fillOval(49, pY3 - 1, 3, 3);
            }
            double pX = 51.0;
            while (dataIdx < (double)len) {
                double y3 = this.data[(int)dataIdx].getValue() / this.yScale;
                double pY4 = this.minY - this.vStep * (y3 - this.bottomLineValue);
                int index = (int)(dataIdx + idxJump);
                if (index < len && !(pX >= (double)(size.width - 45))) {
                    double nextY = this.data[index].getValue() / this.yScale;
                    double pNextY = this.minY - this.vStep * (nextY - this.bottomLineValue);
                    g.drawLine((int)pX, (int)(pY4 > this.minY ? this.minY : pY4), (int)(pX + hStep), (int)(pNextY > this.minY ? this.minY : pNextY));
                    dataIdx += idxJump;
                    pX += hStep;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.data == null ? 0 : this.data.length;
    }

    protected double getTopLineValue() {
        double topLineValue = this.mean + 3.0 * this.stdDev;
        topLineValue = Math.max(topLineValue, this.max);
        if (!Double.isNaN(this.highThreshold)) {
            topLineValue = Math.max(topLineValue, this.highThreshold);
        }
        return topLineValue;
    }

    protected double getBottomLineValue() {
        double bottomLineValue = this.mean - 3.0 * this.stdDev;
        bottomLineValue = Math.min(bottomLineValue, this.min);
        if (!Double.isNaN(this.lowThreshold)) {
            bottomLineValue = Math.min(bottomLineValue, this.lowThreshold);
        }
        return bottomLineValue;
    }

    @Override
    public double getStartValue() {
        return this.startValue;
    }

    @Override
    public void setStartValue(double startValue) {
        this.startValue = startValue;
        if (this.startValue > this.stopRange) {
            this.startValue = this.stopRange;
        }
    }

    @Override
    public double getStopValue() {
        return this.stopValue;
    }

    @Override
    public void setStopValue(double stopValue) {
        this.stopValue = stopValue;
        if (this.stopValue < this.startRange) {
            this.stopValue = this.startRange;
        }
    }
}

