/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.QueuedArchive;

public class FileArchive
extends QueuedArchive {
    private transient PrintWriter writer = null;
    private String filename;
    private String append;
    private boolean appendFlag;

    public FileArchive() {
    }

    public FileArchive(String filename) throws IOException {
        this(new File(filename), false);
    }

    public FileArchive(String filename, boolean appendFlag) throws IOException {
        this(new File(filename), appendFlag);
    }

    public FileArchive(File file) throws IOException {
        this(file, false);
    }

    public FileArchive(File file, boolean appendFlag) throws IOException {
        this(new PrintWriter((Writer)new FileWriter(file.getPath(), appendFlag), true));
    }

    public FileArchive(PrintWriter writer) {
        this.writer = writer;
    }

    public void initialize() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((Writer)new FileWriter(this.filename, this.appendFlag), true);
        }
    }

    @Override
    public void archiveToResource(Calculable calculable) throws IOException {
        if (this.writer != null) {
            this.writer.println(calculable);
        }
    }

    @Override
    public void closeResource() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getAppend() {
        return this.append;
    }

    public void setAppend(String append) {
        this.append = append;
        if (append.equalsIgnoreCase("true")) {
            this.setAppendFlag(true);
        }
    }

    public boolean isAppendFlag() {
        return this.appendFlag;
    }

    public void setAppendFlag(boolean appendFlag) {
        this.appendFlag = appendFlag;
    }
}

