/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import net.jini.config.Configuration;
import org.jini.rio.watch.Archivable;
import org.jini.rio.watch.PeriodicWatchMBean;
import org.jini.rio.watch.ThresholdWatch;
import org.jini.rio.watch.WatchDataSource;

public abstract class PeriodicWatch
extends ThresholdWatch
implements PeriodicWatchMBean {
    public static final long DEFAULT_PERIOD = 30000L;
    private long period = 30000L;
    private Timer watchTimer;

    public PeriodicWatch(String id, Configuration config) {
        super(id, null, config);
        this.watchTimer = new Timer(true);
    }

    public PeriodicWatch(String id, Archivable archivable, Configuration config) {
        super(id, archivable, config);
    }

    public PeriodicWatch(WatchDataSource watchDataSource, String id) {
        super(watchDataSource, id);
    }

    @Override
    public void start() {
        long now = System.currentTimeMillis();
        this.stop();
        this.watchTimer = new Timer(true);
        this.watchTimer.schedule((TimerTask)new PeriodicTask(), new Date(now + this.period), this.period);
    }

    @Override
    public void stop() {
        if (this.watchTimer != null) {
            this.watchTimer.cancel();
        }
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public void setPeriod(long newPeriod) {
        if (newPeriod == this.period) {
            return;
        }
        if (newPeriod <= 0L) {
            throw new IllegalArgumentException("period cannot be less then or equal to zero");
        }
        this.period = newPeriod;
        this.stop();
        this.start();
    }

    class PeriodicTask
    extends TimerTask {
        PeriodicTask() {
        }

        @Override
        public void run() {
            PeriodicWatch.this.checkValue();
        }
    }
}

