/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.jini.rio.watch.Archivable;
import org.jini.rio.watch.Calculable;

public abstract class QueuedArchive
implements Archivable {
    private List archiveQueue = Collections.synchronizedList(new LinkedList());
    private transient Thread archiveChild;
    private static Logger logger = Logger.getLogger("com.sun.sio.watch");

    public QueuedArchive() {
        ArchiveWriter writeThread = new ArchiveWriter(this);
        writeThread.start();
    }

    protected abstract void archiveToResource(Calculable var1) throws IOException;

    protected abstract void closeResource();

    @Override
    public synchronized void close() {
        this.archiveChild.interrupt();
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            logger.warning("Interrupted waiting for close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archive(Calculable calculable) {
        List list = this.archiveQueue;
        synchronized (list) {
            this.archiveQueue.add(calculable);
            this.archiveQueue.notifyAll();
        }
    }

    class ArchiveWriter
    extends Thread {
        private QueuedArchive queuedArchive;

        public ArchiveWriter(QueuedArchive queuedArchive) {
            this.queuedArchive = queuedArchive;
            this.setDaemon(true);
            this.setName(this.getClass().getName() + ":ArchiveWriter");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Calculable calc;
            Object object;
            QueuedArchive.this.archiveChild = Thread.currentThread();
            while (!QueuedArchive.this.archiveChild.isInterrupted()) {
                if (QueuedArchive.this.archiveQueue.isEmpty()) {
                    try {
                        object = QueuedArchive.this.archiveQueue;
                        synchronized (object) {
                            QueuedArchive.this.archiveQueue.wait(30000L);
                            continue;
                        }
                    }
                    catch (InterruptedException ex) {
                        logger.warning("Archive Thread interrupted");
                        continue;
                    }
                }
                calc = (Calculable)QueuedArchive.this.archiveQueue.remove(0);
                try {
                    QueuedArchive.this.archiveToResource(calc);
                }
                catch (IOException ex) {
                    logger.warning("Cannot archive: " + calc + ", " + ex.getMessage());
                }
            }
            while (!QueuedArchive.this.archiveQueue.isEmpty()) {
                calc = (Calculable)QueuedArchive.this.archiveQueue.remove(0);
                try {
                    QueuedArchive.this.archiveToResource(calc);
                }
                catch (IOException ex) {
                    logger.warning("Cannot archive: " + calc + ", " + ex.getMessage());
                }
            }
            QueuedArchive.this.closeResource();
            object = this.queuedArchive;
            synchronized (object) {
                this.queuedArchive.notifyAll();
            }
        }
    }
}

