/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Statistics {
    private Vector v = new Vector();

    public Statistics() {
    }

    public Statistics(Vector vector) {
        this.setValues(vector);
    }

    public void clearAll() {
        this.v.clear();
    }

    public int count() {
        return this.v.size();
    }

    public double max() throws ClassCastException, NoSuchElementException {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        return (Double)Collections.max(this.v);
    }

    public double min() throws ClassCastException, NoSuchElementException {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        return (Double)Collections.min(this.v);
    }

    public double mean() {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        double sum = 0.0;
        sum = this.sum();
        return sum / (double)this.v.size();
    }

    public double median() {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        double result = 0.0;
        Vector sortedV = this.sorted();
        Double[] dArray = new Double[this.v.size()];
        if ((dArray = sortedV.toArray(dArray)).length % 2 != 0 && dArray.length > 0) {
            int k = (dArray.length - 1) / 2;
            result = dArray[k];
        } else {
            int k = (dArray.length - 1) / 2;
            result = (dArray[k] + dArray[k + 1]) / 2.0;
        }
        return result;
    }

    public double mode() {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        return (Double)this.mode0(true);
    }

    public int modeOccurrenceCount() {
        if (this.v.isEmpty()) {
            return 0;
        }
        return (Integer)this.mode0(false);
    }

    private Object mode0(boolean returnMode) {
        Iterator it = this.v.iterator();
        Hashtable hashtable = new Hashtable(this.v.size());
        Integer occurrences = new Integer(0);
        int modeCnt = 0;
        Double mode = new Double(0.0);
        for (Object obj : this.v) {
            modeCnt = hashtable.containsKey(obj) ? (Integer)hashtable.get(obj) + 1 : 1;
            hashtable.put(obj, new Integer(modeCnt));
        }
        if (returnMode) {
            return mode;
        }
        return occurrences;
    }

    public double range() {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        return this.max() - this.min();
    }

    public double standardDeviation() {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        if (this.v.size() == 1) {
            return 0.0;
        }
        double sum = this.sum();
        double sumOfSquares = 0.0;
        Iterator it = this.v.iterator();
        while (it.hasNext()) {
            sumOfSquares += Math.pow((Double)it.next(), 2.0);
        }
        return Math.sqrt((sumOfSquares - Math.pow(sum, 2.0) / (double)this.v.size()) / (double)(this.v.size() - 1));
    }

    public Vector getValues() {
        return (Vector)this.v.clone();
    }

    public void addValue(Double double1) {
        if (double1 == null) {
            throw new NullPointerException("value is null");
        }
        this.v.addElement(double1);
    }

    public void addValue(double d) {
        this.v.addElement(new Double(d));
    }

    public void setValues(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("vector is null");
        }
        this.v.clear();
        this.v.addAll(vector);
    }

    public void removeValues(double d, boolean removeAll) {
        Double double1 = new Double(d);
        this.removeValues(double1, removeAll);
    }

    public void removeValues(Double double1, boolean removeAll) {
        if (double1 == null) {
            throw new NullPointerException("value is null");
        }
        if (removeAll) {
            Vector<Double> toRemove = new Vector<Double>(1);
            toRemove.add(double1);
            this.v.removeAll(toRemove);
        } else {
            this.v.removeElement(double1);
        }
    }

    public void removeValue(int location) {
        if (location < this.v.size() && location >= 0) {
            this.v.removeElementAt(location);
        }
    }

    public void removeValues(Double low, Double high) {
        if (low == null) {
            throw new NullPointerException("low is null");
        }
        if (high == null) {
            throw new NullPointerException("high is null");
        }
        this.removeValues((double)low, (double)high);
    }

    public void removeValues(double low, double high) {
        for (int i = 0; i < this.v.size(); ++i) {
            if (!((Double)this.v.elementAt(i) >= low) || !((Double)this.v.elementAt(i) <= high)) continue;
            this.v.removeElementAt(i);
            --i;
        }
    }

    public double sum() {
        if (this.v.isEmpty()) {
            return Double.NaN;
        }
        double tot = 0.0;
        Iterator it = this.v.iterator();
        while (it.hasNext()) {
            tot += ((Double)it.next()).doubleValue();
        }
        return tot;
    }

    private Vector sorted() {
        Vector cpy = (Vector)this.v.clone();
        Collections.sort(cpy);
        return cpy;
    }
}

