/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import net.jini.config.Configuration;
import org.jini.rio.watch.Archivable;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.StopWatchMBean;
import org.jini.rio.watch.ThresholdWatch;
import org.jini.rio.watch.WatchDataSource;

public class StopWatch
extends ThresholdWatch
implements StopWatchMBean {
    public static final String VIEW = "org.jini.rio.watch.ResponseTimeCalculableView";
    private long startTime;

    public StopWatch(String id, Configuration config) {
        super(id, null, config);
        this.setView(VIEW);
    }

    public StopWatch(String id, Archivable archivable, Configuration config) {
        super(id, archivable, config);
        this.setView(VIEW);
    }

    public StopWatch(WatchDataSource watchDataSource, String id) {
        super(watchDataSource, id);
        this.setView(VIEW);
    }

    @Override
    public void startTiming() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void stopTiming() {
        long now = System.currentTimeMillis();
        this.setElapsedTime(now - this.startTime, now);
    }

    @Override
    public void setElapsedTime(long elapsed) {
        this.setElapsedTime(elapsed, System.currentTimeMillis());
    }

    @Override
    public void setElapsedTime(long elapsed, long now) {
        this.addWatchRecord(new Calculable(this.id, (double)elapsed, now));
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }
}

