/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.rmi.RemoteException;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.event.EventDescriptor;
import org.jini.rio.event.EventHandler;
import org.jini.rio.event.NoEventConsumerException;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdEvent;
import org.jini.rio.watch.ThresholdListener;
import org.jini.rio.watch.ThresholdManager;
import org.jini.rio.watch.WatchDataSource;

public class ThresholdEventHandler
implements ThresholdListener {
    protected EventHandler eventHandler = null;
    public static final EventDescriptor eventDescriptor = new EventDescriptor(ThresholdEvent.class, new Long(1000000000L));
    private ThresholdEvent event = null;

    public ThresholdEventHandler() {
    }

    public ThresholdEventHandler(WatchDataSource source) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        this.setEvent(new ThresholdEvent(source));
    }

    public ThresholdEventHandler(WatchDataSource source, EventHandler eventHandler) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        this.setEvent(new ThresholdEvent(source));
        this.setEventHandler(eventHandler);
    }

    public ThresholdEventHandler(ThresholdEvent event, EventHandler eventHandler) {
        this.setEvent(event);
        this.setEventHandler(eventHandler);
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public void setThresholdManager(ThresholdManager thresholdManager) {
        if (thresholdManager == null) {
            throw new NullPointerException("thresholdManager is null");
        }
        thresholdManager.addThresholdListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Calculable calculable, ThresholdValues thresholdValues, int type) {
        if (this.eventHandler != null && this.event != null) {
            try {
                ThresholdEvent thresholdEvent = this.event;
                synchronized (thresholdEvent) {
                    this.event.setCalculable(calculable);
                    this.event.setThresholdValues(thresholdValues);
                    this.event.setType(type);
                    this.eventHandler.fire(this.event);
                }
            }
            catch (NoEventConsumerException nec) {
                nec.printStackTrace();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            throw new NullPointerException("eventHandler is null");
        }
        this.eventHandler = eventHandler;
    }

    public ThresholdEvent getEvent() {
        return this.event;
    }

    public void setEvent(ThresholdEvent event) {
        if (event == null) {
            throw new NullPointerException("event is null");
        }
        this.event = event;
    }

    public static EventDescriptor getEventDescriptor() {
        return eventDescriptor;
    }
}

