/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdListener;

public abstract class ThresholdManager {
    protected transient LinkedList thresholdListeners = new LinkedList();
    protected ThresholdValues thresholdValues = new ThresholdValues();
    static Logger logger = Logger.getLogger("org.jini.rio.watch");

    public abstract void checkThreshold(Calculable var1);

    public abstract boolean getThresholdCrossed();

    public ThresholdValues getThresholdValues() {
        return this.thresholdValues;
    }

    public void setThresholdValues(ThresholdValues thresholdValues) {
        this.thresholdValues = thresholdValues;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Set ThresholdValues, low={0}, high={1}", new Object[]{new Double(thresholdValues.getLowThreshold()), new Double(thresholdValues.getHighThreshold())});
        }
    }

    protected void notifyListeners(Calculable calculable, int type) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Notify ThresholdListeners");
        }
        ThresholdValues thresholds = (ThresholdValues)this.thresholdValues.clone();
        ThresholdListener[] tListeners = this.getThresholdListeners();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Number ThresholdListeners [" + tListeners.length + "]");
        }
        for (int i = 0; i < tListeners.length; ++i) {
            tListeners[i].notify(calculable, thresholds, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThresholdListener(ThresholdListener listener) {
        LinkedList linkedList = this.thresholdListeners;
        synchronized (linkedList) {
            if (!this.thresholdListeners.contains(listener)) {
                this.thresholdListeners.add(listener);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Number ThresholdListeners [" + this.thresholdListeners.size() + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThresholdListener(ThresholdListener listener) {
        LinkedList linkedList = this.thresholdListeners;
        synchronized (linkedList) {
            this.thresholdListeners.remove(listener);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Number ThresholdListeners [" + this.thresholdListeners.size() + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdListener[] getThresholdListeners() {
        ThresholdListener[] tListeners = null;
        LinkedList linkedList = this.thresholdListeners;
        synchronized (linkedList) {
            tListeners = this.thresholdListeners.toArray(new ThresholdListener[this.thresholdListeners.size()]);
        }
        return tListeners;
    }
}

