/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.rmi.RemoteException;
import java.util.logging.Level;
import net.jini.config.Configuration;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.watch.Archivable;
import org.jini.rio.watch.BoundedThresholdManager;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.ThresholdListener;
import org.jini.rio.watch.ThresholdManager;
import org.jini.rio.watch.ThresholdWatchMBean;
import org.jini.rio.watch.Watch;
import org.jini.rio.watch.WatchDataSource;

public abstract class ThresholdWatch
extends Watch
implements ThresholdWatchMBean {
    static final String VIEW = "org.jini.rio.watch.ThresholdCalculableView";
    private ThresholdManager thresholdManager = new BoundedThresholdManager();

    public ThresholdWatch(String id, Configuration config) {
        super(id, null, config);
        this.setView(VIEW);
    }

    public ThresholdWatch(String id, Archivable archivable, Configuration config) {
        super(id, archivable, config);
        this.setView(VIEW);
    }

    public ThresholdWatch(WatchDataSource watchDataSource, String id) {
        super(watchDataSource, id);
        this.setView(VIEW);
    }

    public ThresholdManager getThresholdManager() {
        return this.thresholdManager;
    }

    public void addThresholdListener(ThresholdListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.thresholdManager.addThresholdListener(listener);
    }

    public void removeThresholdListener(ThresholdListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.thresholdManager.removeThresholdListener(listener);
    }

    public void setThresholdValues(ThresholdValues tValues) {
        if (tValues == null) {
            throw new NullPointerException("tValues is null");
        }
        this.thresholdManager.setThresholdValues(tValues);
        if (this.localRef != null) {
            this.localRef.setThresholdValues(this.getThresholdValues());
        } else {
            try {
                this.watchDataSource.setThresholdValues(this.getThresholdValues());
            }
            catch (RemoteException e) {
                logger.log(Level.WARNING, "Setting ThresholdValues for a remote WatchDataSource", e);
            }
        }
    }

    public ThresholdValues getThresholdValues() {
        return this.thresholdManager.getThresholdValues();
    }

    @Override
    public void addWatchRecord(Calculable record) {
        super.addWatchRecord(record);
        this.thresholdManager.checkThreshold(record);
    }

    @Override
    public double getHighThreshold() {
        return this.getThresholdValues().getHighThreshold();
    }

    @Override
    public double getLowThreshold() {
        return this.getThresholdValues().getLowThreshold();
    }

    @Override
    public double getCurrentHighThreshold() {
        return this.getThresholdValues().getCurrentHighThreshold();
    }

    @Override
    public void setCurrentHighThreshold(double threshold) {
        ThresholdValues tVals = this.getThresholdValues();
        tVals.setCurrentHighThreshold(threshold);
        this.thresholdManager.setThresholdValues(tVals);
    }

    @Override
    public void setCurrentLowThreshold(double threshold) {
        ThresholdValues tVals = this.getThresholdValues();
        tVals.setCurrentLowThreshold(threshold);
        this.thresholdManager.setThresholdValues(tVals);
    }

    @Override
    public double getCurrentLowThreshold() {
        return this.getThresholdValues().getCurrentLowThreshold();
    }

    @Override
    public long getBreachedCount() {
        return this.getThresholdValues().getThresholdBreachedCount();
    }

    @Override
    public long getClearedCount() {
        return this.getThresholdValues().getThresholdClearedCount();
    }
}

