/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import net.jini.config.Configuration;
import net.jini.config.EmptyConfiguration;
import org.jini.rio.jmx.JMXUtil;
import org.jini.rio.watch.Archivable;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.WatchDataSource;
import org.jini.rio.watch.WatchDataSourceImpl;
import org.jini.rio.watch.WatchMBean;

public class Watch
implements WatchMBean {
    protected volatile WatchDataSource watchDataSource;
    protected String id;
    protected WatchDataSourceImpl localRef;
    protected static final Logger logger = Logger.getLogger("org.jini.rio.watch");
    private static final String DEFAULT_VIEW = "org.jini.rio.watch.DefaultCalculableView";
    private String view = "org.jini.rio.watch.DefaultCalculableView";

    public Watch(String id, Configuration config) {
        this(id, null, config);
    }

    public Watch(String id, Archivable archivable, Configuration config) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.id = id;
        try {
            this.localRef = new WatchDataSourceImpl(id, archivable, config);
            this.localRef.setView(this.getView());
            this.watchDataSource = this.localRef.export();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Creating WatchDataSourceImpl for Watch [" + id + "]", t);
        }
    }

    public Watch(WatchDataSource watchDataSource, String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (watchDataSource == null) {
            throw new NullPointerException("watchDataSource is null");
        }
        this.id = id;
        this.setWatchDataSource(watchDataSource);
    }

    public WatchDataSource getWatchDataSource() {
        return this.watchDataSource;
    }

    public void setWatchDataSource(WatchDataSource watchDataSource) {
        if (watchDataSource == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("WatchDataSource is null for Watch=" + this.id);
            }
            return;
        }
        this.watchDataSource = watchDataSource;
        this.localRef = null;
        try {
            watchDataSource.setView(this.getView());
        }
        catch (RemoteException e) {
            logger.log(Level.SEVERE, "Setting WatchDataSource View", e);
        }
    }

    public String getView() {
        return this.view;
    }

    public void setView(String viewClass) {
        if (viewClass == null) {
            throw new NullPointerException("viewClass is null");
        }
        this.view = viewClass;
        if (this.localRef != null) {
            this.localRef.setView(viewClass);
        } else if (this.watchDataSource != null) {
            try {
                this.watchDataSource.setView(viewClass);
            }
            catch (RemoteException e) {
                logger.log(Level.WARNING, "Setting View class for Watch [" + this.getId() + "]", e);
            }
        } else {
            logger.severe("WatchDataSource is null for Watch " + this.getId());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getLastCalculableValue() {
        double value = 0.0;
        try {
            Calculable lastCalculable = this.watchDataSource.getLastCalculable();
            if (lastCalculable != null) {
                value = lastCalculable.getValue();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Getting last calculable", e);
        }
        return value;
    }

    @Override
    public TabularData getCalculables() {
        try {
            Calculable[] calculables = this.watchDataSource.getCalculable();
            if (calculables == null || calculables.length == 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No Calculables Available From Data Source:" + this.watchDataSource.getID());
                }
                return null;
            }
            CompositeType type = JMXUtil.createCompositeType(JMXUtil.toMap(calculables[0]), "Calculable", "Calculable");
            TabularType tabularType = new TabularType("Calculables", "Calculables", type, new String[]{"when"});
            TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
            for (int i = 0; i < calculables.length; ++i) {
                Calculable calculable = calculables[i];
                CompositeDataSupport compositeData = new CompositeDataSupport(type, JMXUtil.toMap(calculable));
                tabularDataSupport.put(compositeData);
            }
            return tabularDataSupport;
        }
        catch (OpenDataException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (IntrospectionException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        return null;
    }

    @Override
    public void clear() {
        try {
            this.watchDataSource.clear();
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
    }

    public void addWatchRecord(Calculable calc) {
        if (this.localRef != null) {
            this.localRef.addCalculable(calc);
            return;
        }
        if (this.watchDataSource == null) {
            logger.severe("WatchDataSource is null for Watch " + this.getId());
            return;
        }
        try {
            this.watchDataSource.addCalculable(calc);
        }
        catch (RemoteException e) {
            logger.log(Level.SEVERE, "WatchDataSource not available for Watch " + this.getId(), e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Watch) {
            if (this.getId() == null && ((Watch)obj).getId() == null) {
                return true;
            }
            if (this.getId() == null || ((Watch)obj).getId() == null) {
                return false;
            }
            return this.getId().equals(((Watch)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + (this.id != null ? this.id.hashCode() : 0);
        return hc;
    }

    public String toString() {
        return this.id == null ? "null" : this.id;
    }

    public static void main(String[] args) {
        try {
            Watch w = new Watch("Test", (Configuration)EmptyConfiguration.INSTANCE);
            w.addWatchRecord(new Calculable("test", 5.4));
            w.addWatchRecord(new Calculable("test1", 1.1));
            w.addWatchRecord(new Calculable("test2", 2.2));
            w.addWatchRecord(new Calculable("test", 3.2));
            w.addWatchRecord(new Calculable("test", 2.1));
            Thread.sleep(1000L);
            System.out.println("Main: Ready to Interrupt");
            System.out.flush();
            Calculable[] c = w.getWatchDataSource().getCalculable();
            for (int i = 0; i < c.length; ++i) {
                System.out.println(i + "). " + c[i]);
            }
            System.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.flush();
        System.exit(0);
    }
}

