/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import com.sun.jini.config.Config;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.export.Exporter;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.config.ExporterConfig;
import org.jini.rio.core.ThresholdValues;
import org.jini.rio.watch.Archivable;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.NullArchive;
import org.jini.rio.watch.WatchDataSource;

public class WatchDataSourceImpl
implements WatchDataSource,
ServerProxyTrust {
    private List queue = Collections.synchronizedList(new LinkedList());
    private transient Thread writerThread;
    private int offset = 0;
    public static final int DEFAULT_COLLECTION_SIZE = 1000;
    public static final int MAX_COLLECTION_SIZE = 10000;
    private int max = 1000;
    private ArrayList history;
    private String id = null;
    private Archivable archivable;
    private String viewClass;
    private ThresholdValues thresholdValues = new ThresholdValues();
    private Configuration config;
    private Exporter exporter;
    private WatchDataSource proxy;
    private boolean exported = false;
    private static final String COMPONENT = "org.jini.rio.watch";
    private static Logger logger = Logger.getLogger("org.jini.rio.watch");

    public WatchDataSourceImpl(String id, Archivable archivable, Configuration config) {
        this.setID(id);
        if (archivable != null) {
            this.setArchivable(archivable);
        } else {
            this.setArchivable(new NullArchive());
        }
        this.config = config;
        int collectionSize = 1000;
        try {
            collectionSize = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"collectionSize", (int)1000, (int)1, (int)10000);
        }
        catch (ConfigurationException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Getting WatchDataSource collection size", e);
            }
            collectionSize = 1000;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Watch [" + id + "] history collection size=" + collectionSize);
        }
        this.max = collectionSize;
        this.history = new ArrayList(collectionSize);
        this.startWriter();
    }

    public WatchDataSource export() throws RemoteException {
        if (this.exported && this.proxy != null) {
            return this.proxy;
        }
        if (this.config != null) {
            try {
                this.exporter = ExporterConfig.getExporter(this.config, COMPONENT, "watchDataSourceExporter");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Getting watchDataSourceExporter", e);
            }
        }
        this.proxy = (WatchDataSource)this.exporter.export((Remote)((Object)this));
        this.exported = true;
        return this.proxy;
    }

    public void unexport(boolean force) {
        if (!this.exported) {
            return;
        }
        try {
            this.exporter.unexport(force);
            this.exported = false;
            this.proxy = null;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public WatchDataSource getProxy() {
        return this.proxy;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        this.id = id;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized void setSize(int size) {
        if (size < this.max) {
            this.max = size;
            if (this.history.size() > size) {
                this.trimHistory(this.history.size() - size - 1);
                this.history.trimToSize();
            }
        } else {
            this.history.ensureCapacity(size);
        }
        this.max = size;
    }

    public synchronized void clear() {
        this.history.clear();
    }

    private synchronized void trimHistory(int range) {
        if (range == 1) {
            this.history.remove(0);
        } else {
            List subList = this.history.subList(0, range);
            subList.clear();
            Object var2_2 = null;
        }
        this.offset += range;
    }

    public synchronized int getSize() {
        return this.max;
    }

    public int getCurrentSize() {
        return this.history.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCalculable(Calculable calculable) {
        if (calculable == null) {
            throw new NullPointerException("calculable is null");
        }
        List list = this.queue;
        synchronized (list) {
            this.queue.add(calculable);
            this.queue.notifyAll();
        }
    }

    private synchronized void addToHistory(Calculable calculable) {
        if (this.history.size() == this.max) {
            this.trimHistory(1);
        }
        if (this.history.size() > this.max) {
            this.trimHistory(this.history.size() - this.max - 1);
        }
        this.history.add(calculable);
    }

    private void startWriter() {
        if (this.writerThread != null) {
            return;
        }
        Writer writer = new Writer();
        writer.setName(this.id + ":writer");
        writer.setDaemon(true);
        writer.start();
    }

    public Archivable getArchivable() {
        return this.archivable;
    }

    public void setArchivable(Archivable archivable) {
        if (archivable == null) {
            archivable = new NullArchive();
        }
        this.archivable = archivable;
    }

    public synchronized Calculable[] getCalculable() {
        return this.history.toArray(new Calculable[this.history.size()]);
    }

    public Calculable[] getCalculable(String id) {
        return this.getCalculable(id, 0, this.history.size());
    }

    public synchronized Calculable[] getCalculable(int offset, int length) {
        offset = (offset -= this.offset) < 0 ? 0 : offset;
        length = Math.min(length, this.history.size() - offset);
        return this.history.subList(offset, offset + length).toArray(new Calculable[length]);
    }

    public synchronized Calculable[] getCalculable(String id, int offset, int length) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        offset = (offset -= this.offset) < 0 ? 0 : offset;
        length = Math.min(length, this.history.size() - offset);
        List list = this.history.subList(offset, offset + length);
        ArrayList<Calculable> result = new ArrayList<Calculable>(length);
        for (Calculable calc : list) {
            if (!calc.getId().equals(id)) continue;
            result.add(calc);
        }
        return result.toArray(new Calculable[result.size()]);
    }

    public synchronized Calculable getLastCalculable() {
        try {
            return (Calculable)this.history.get(this.history.size() - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public synchronized Calculable getLastCalculable(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        for (int i = this.history.size() - 1; i >= 0; --i) {
            Calculable calc = (Calculable)this.history.get(i);
            if (!calc.getId().equals(id)) continue;
            return calc;
        }
        return null;
    }

    protected void finalize() {
        if (this.archivable != null) {
            this.archivable.close();
        }
    }

    public ThresholdValues getThresholdValues() {
        return this.thresholdValues;
    }

    public void setThresholdValues(ThresholdValues tValues) {
        if (tValues != null) {
            this.thresholdValues = tValues;
        }
    }

    public void close() {
        if (this.writerThread != null && this.writerThread.isAlive()) {
            this.writerThread.interrupt();
        }
        if (this.archivable != null) {
            this.archivable.close();
            this.archivable = null;
        }
        this.unexport(true);
    }

    public void setView(String viewClass) {
        this.viewClass = viewClass;
    }

    public String getView() {
        return this.viewClass;
    }

    public TrustVerifier getProxyVerifier() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(this.getClass().getName(), "getProxyVerifier");
        }
        return new BasicProxyTrustVerifier((Object)this.proxy);
    }

    class Writer
    extends Thread {
        Writer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WatchDataSourceImpl.this.writerThread = Thread.currentThread();
            while (!WatchDataSourceImpl.this.writerThread.isInterrupted()) {
                if (WatchDataSourceImpl.this.queue.isEmpty()) {
                    try {
                        List list = WatchDataSourceImpl.this.queue;
                        synchronized (list) {
                            WatchDataSourceImpl.this.queue.wait(30000L);
                            continue;
                        }
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
                Calculable calc = (Calculable)WatchDataSourceImpl.this.queue.remove(0);
                WatchDataSourceImpl.this.addToHistory(calc);
                if (WatchDataSourceImpl.this.archivable == null) continue;
                WatchDataSourceImpl.this.archivable.archive(calc);
            }
        }
    }
}

