/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.jmx.JMXUtil;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.qos.SLAPolicyHandler;
import org.jini.rio.watch.ThresholdListener;
import org.jini.rio.watch.ThresholdWatch;
import org.jini.rio.watch.Watch;
import org.jini.rio.watch.WatchDataSource;
import org.jini.rio.watch.WatchRegistry;

public class WatchDataSourceRegistry
implements WatchRegistry {
    protected Vector watchRegistry = new Vector();
    protected Hashtable thresholdListenerTable = new Hashtable();
    private ServiceBeanContext context;
    private static Logger logger = Logger.getLogger("org.jini.rio.watch");

    @Override
    public void deregister(Watch watch) {
        if (watch == null) {
            throw new NullPointerException("Watch cannot be null");
        }
        this.watchRegistry.remove(watch);
        try {
            watch.getWatchDataSource().close();
        }
        catch (NoSuchObjectException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Deregistering Watch", e);
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Deregistering Watch", t);
        }
        this.unregisterJMX(watch);
    }

    private void unregisterJMX(Watch watch) {
        try {
            ObjectName objectName = this.getObjectName(watch);
            if (MBeanServerFactory.getMBeanServer().isRegistered(objectName)) {
                MBeanServerFactory.getMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (MalformedObjectNameException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (InstanceNotFoundException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (MBeanRegistrationException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void closeAll() {
        WatchDataSource[] wds = this.fetch();
        for (int i = 0; i < wds.length; ++i) {
            try {
                Watch[] w = this.findWatch(wds[i].getID());
                for (int j = 0; j < w.length; ++j) {
                    this.unregisterJMX(w[j]);
                }
            }
            catch (RemoteException e) {
                logger.log(Level.WARNING, "Getting Watch from WatchDataSource", e);
            }
            try {
                if (wds[i] == null) continue;
                wds[i].close();
                continue;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Closing WatchDataSource", t);
            }
        }
    }

    @Override
    public void register(Watch watch) {
        if (watch == null) {
            throw new NullPointerException("Watch cannot be null");
        }
        this.watchRegistry.add(watch);
        this.associateThresholdListener(watch);
        this.registerJMX(watch);
    }

    private void registerJMX(Watch watch) {
        try {
            ObjectName objectName = this.getObjectName(watch);
            MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
            mbeanServer.registerMBean(watch, objectName);
        }
        catch (MalformedObjectNameException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (MBeanRegistrationException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
        catch (NotCompliantMBeanException e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
    }

    private ObjectName getObjectName(Watch watch) throws MalformedObjectNameException {
        String domain = this.getClass().getPackage().getName();
        String objectName = null;
        if (this.context != null) {
            String jmxName = JMXUtil.getJMXName(this.context, domain);
            objectName = jmxName + ",name=Watch,id=" + watch.getId();
        }
        if (objectName == null) {
            objectName = domain + ":type=Watch,ID=" + watch.getId();
        }
        return ObjectName.getInstance(objectName);
    }

    @Override
    public void addThresholdListener(String id, ThresholdListener thresholdListener) {
        Collection<ThresholdListener> collection;
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (thresholdListener == null) {
            throw new NullPointerException("thresholdListener is null");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Add [" + thresholdListener.getClass().getName() + "] for watch [" + id + "]");
        }
        if (this.thresholdListenerTable.containsKey(id)) {
            collection = (Collection)this.thresholdListenerTable.get(id);
            collection.add(thresholdListener);
            this.thresholdListenerTable.put(id, collection);
        } else {
            collection = new Vector<ThresholdListener>();
            collection.add(thresholdListener);
            this.thresholdListenerTable.put(id, collection);
        }
        Watch[] watches = this.findWatch(id);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Found [" + watches.length + "] previously registered watch [" + id + "]");
        }
        if (watches.length > 0) {
            for (int i = 0; i < watches.length; ++i) {
                this.associateThresholdListener(watches[i]);
            }
        }
    }

    protected void associateThresholdListener(Watch watch) {
        if (!(watch instanceof ThresholdWatch)) {
            return;
        }
        ThresholdWatch tWatch = (ThresholdWatch)watch;
        if (this.thresholdListenerTable.containsKey(tWatch.getId())) {
            Collection collection = (Collection)this.thresholdListenerTable.get(tWatch.getId());
            for (ThresholdListener tListener : collection) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Associate Watch [" + tWatch.getId() + "] to [" + tListener.getClass().getName() + "]");
                }
                if (tListener instanceof SLAPolicyHandler) {
                    tWatch.setThresholdValues(((SLAPolicyHandler)tListener).getSLA());
                }
                tListener.setThresholdManager(tWatch.getThresholdManager());
            }
        }
    }

    @Override
    public Watch[] findWatch(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        Vector<Watch> matches = new Vector<Watch>();
        Enumeration e = this.watchRegistry.elements();
        while (e.hasMoreElements()) {
            Watch watch = (Watch)e.nextElement();
            if (!id.equals(watch.getId())) continue;
            matches.add(watch);
        }
        return matches.toArray(new Watch[matches.size()]);
    }

    @Override
    public WatchDataSource[] fetch() {
        WatchDataSource[] wds = new WatchDataSource[this.watchRegistry.size()];
        int i = 0;
        Enumeration e = this.watchRegistry.elements();
        while (e.hasMoreElements()) {
            Watch watch = (Watch)e.nextElement();
            wds[i] = watch.getWatchDataSource();
            ++i;
        }
        return wds;
    }

    @Override
    public WatchDataSource[] fetch(String id) {
        WatchDataSource[] wds = null;
        Watch[] watches = this.findWatch(id);
        if (watches != null) {
            wds = new WatchDataSource[watches.length];
            for (int i = 0; i < watches.length; ++i) {
                wds[i] = watches[i].getWatchDataSource();
            }
        }
        return wds;
    }

    @Override
    public void setServiceBeanContext(ServiceBeanContext context) {
        this.context = context;
    }
}

