/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.io.Serializable;

public class WatchDescriptor
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final String GAUGE = "gauge";
    public static final String COUNTER = "counter";
    public static final String STOP_WATCH = "stopwatch";
    public static final String UNDEFINED = "?";
    public static final long DEFAULT_PERIOD = 10000L;
    private String name;
    private String type;
    private String property;
    private long period;

    public WatchDescriptor(String name, String type, String property, long period) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (property == null) {
            throw new NullPointerException("property is null");
        }
        this.name = name;
        this.type = type;
        this.property = property;
        this.period = period == 0L ? 10000L : period;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getProperty() {
        return this.property;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean isObjectName() {
        return this.property.indexOf(":") != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchDescriptor that = (WatchDescriptor)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "name=" + this.name + ", type=" + this.type + ", property=" + this.property + ", period=" + this.period;
    }
}

