/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.watch;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.watch.Calculable;
import org.jini.rio.watch.CounterWatch;
import org.jini.rio.watch.GaugeWatch;
import org.jini.rio.watch.StopWatch;
import org.jini.rio.watch.ThresholdWatch;
import org.jini.rio.watch.Watch;
import org.jini.rio.watch.WatchDescriptor;

public class WatchInjector {
    private Object impl;
    private PropertyDescriptor[] pds;
    private Timer taskTimer;
    private ServiceBeanContext context;
    private ArrayList createdWatches = new ArrayList();
    private HashMap watchTasks = new HashMap();
    static final String COMPONENT = "org.jini.rio.watch.WatchInjector";
    static final Logger logger = Logger.getLogger("org.jini.rio.watch.WatchInjector");

    public WatchInjector(Object impl, ServiceBeanContext context) throws IntrospectionException {
        if (impl == null) {
            throw new NullPointerException("impl is null");
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        this.impl = impl;
        this.context = context;
        Class<?> aClass = impl.getClass();
        BeanInfo bi = Introspector.getBeanInfo(aClass);
        this.pds = bi.getPropertyDescriptors();
        this.taskTimer = new Timer(true);
    }

    public Watch inject(WatchDescriptor wDesc) throws ConfigurationException {
        if (wDesc == null) {
            throw new NullPointerException("wDesc is null");
        }
        Watch watch = null;
        if (this.context.getWatchRegistry().findWatch(wDesc.getName()).length > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WatchDescriptor for Watch[" + wDesc.getName() + "], found on target object's WatchRegistry [" + this.impl.getClass().getName() + "]");
            }
            return this.context.getWatchRegistry().findWatch(wDesc.getName())[0];
        }
        boolean propertyMatch = false;
        String propertyName = wDesc.getProperty();
        if (propertyName.equals("?")) {
            logger.warning("WatchDescriptor for Watch[" + wDesc.getName() + "], has undefined property name");
            return null;
        }
        for (int i = 0; i < this.pds.length; ++i) {
            String propName = this.pds[i].getName();
            if (!propName.equals(propertyName)) continue;
            propertyMatch = true;
            Method accessor = this.pds[i].getReadMethod();
            if (accessor != null) {
                this.verifyReturnType(accessor.getReturnType(), wDesc);
                watch = this.createWatch(wDesc, this.context.getConfiguration());
                this.context.getWatchRegistry().register(watch);
                WatchTask watchTask = new WatchTask(watch, accessor, wDesc);
                this.createdWatches.add(watch);
                this.watchTasks.put(wDesc.getName(), watchTask);
                this.taskTimer.schedule((TimerTask)watchTask, 0L, wDesc.getPeriod());
                continue;
            }
            logger.warning("WatchDescriptor [" + wDesc.toString() + "], with declared propertyName [" + propertyName + "], matched, no readMethod found on target object [" + this.impl.getClass().getName() + "]");
        }
        if (!propertyMatch) {
            logger.warning("WatchDescriptor [" + wDesc.toString() + "], with declared propertyName [" + propertyName + "] not found on target object [" + this.impl.getClass().getName() + "]");
        }
        return watch;
    }

    public void terminate() {
        for (Map.Entry mapEntry : this.watchTasks.entrySet()) {
            WatchTask wTask = (WatchTask)mapEntry.getValue();
            wTask.cancel();
        }
        this.taskTimer.cancel();
    }

    protected Watch createWatch(WatchDescriptor wDesc, Configuration config) {
        ThresholdWatch watch = null;
        if (wDesc.getType().equals("counter")) {
            watch = new CounterWatch(wDesc.getName(), config);
        } else if (wDesc.getType().equals("gauge")) {
            watch = new GaugeWatch(wDesc.getName(), config);
        } else if (wDesc.getType().equals("stopwatch")) {
            watch = new StopWatch(wDesc.getName(), config);
        }
        return watch;
    }

    private Watch[] getWatches() {
        Watch[] watches = new Watch[this.createdWatches.size()];
        for (int i = 0; i < watches.length; ++i) {
            watches[i] = (Watch)this.createdWatches.get(i);
        }
        return watches;
    }

    public String[] getWatchNames() {
        String[] names = new String[this.createdWatches.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((Watch)this.createdWatches.get(i)).getId();
        }
        return names;
    }

    private Watch getWatch(String name) {
        Watch watch = null;
        Watch[] watches = this.getWatches();
        for (int i = 0; i < watches.length; ++i) {
            if (!watches[i].getId().equals(name)) continue;
            watch = watches[i];
            break;
        }
        return watch;
    }

    public WatchDescriptor getWatchDescriptor(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        WatchDescriptor wDesc = null;
        WatchTask wTask = (WatchTask)this.watchTasks.get(name);
        if (wTask != null) {
            wDesc = wTask.getWatchDescriptor();
        }
        return wDesc;
    }

    public void modify(WatchDescriptor wDesc) throws ConfigurationException {
        if (wDesc == null) {
            throw new NullPointerException("wDesc is null");
        }
        Watch watch = this.getWatch(wDesc.getName());
        if (watch == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unable to modify Watch [" + wDesc.getName() + "], not created by the WatchInjector");
            }
            return;
        }
        WatchTask wTask = (WatchTask)this.watchTasks.get(watch.getId());
        WatchDescriptor currentDesc = wTask.getWatchDescriptor();
        boolean change = false;
        if (wDesc.getPeriod() != currentDesc.getPeriod()) {
            change = true;
        } else if (!wDesc.getName().equals(currentDesc.getName())) {
            change = true;
        } else if (!wDesc.getProperty().equals(currentDesc.getProperty())) {
            change = true;
        }
        if (change) {
            this.remove(currentDesc);
            this.inject(wDesc);
        }
    }

    public void remove(WatchDescriptor wDesc) {
        if (wDesc == null) {
            throw new NullPointerException("wDesc is null");
        }
        Watch watch = this.getWatch(wDesc.getName());
        if (watch == null) {
            logger.warning("Unable to remove Watch [" + wDesc.getName() + "], not created by the WatchInjector");
            return;
        }
        if (this.createdWatches.remove(watch)) {
            this.context.getWatchRegistry().deregister(watch);
        }
        WatchTask wTask = (WatchTask)this.watchTasks.remove(watch.getId());
        wTask.cancel();
    }

    public void remove(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        WatchDescriptor wDesc = null;
        WatchTask wTask = (WatchTask)this.watchTasks.get(name);
        if (wTask != null) {
            wDesc = wTask.getWatchDescriptor();
        }
        this.remove(wDesc);
    }

    private void verifyReturnType(Class type, WatchDescriptor wDesc) {
        if (type.isPrimitive()) {
            if (type != Integer.TYPE && type != Long.TYPE && type != Float.TYPE && type != Double.TYPE) {
                throw new Error("Unsupported primitive return type: " + type + " for declared watch=[" + wDesc.getName() + "], property=[" + wDesc.getProperty() + "]. Supported types are [int, long, float, double]");
            }
        } else if (type != Integer.class && type != Long.class && type != Float.class && type != Double.class) {
            throw new Error("Unsupported return type: " + type + " for declared watch=[" + wDesc.getName() + "], property=[" + wDesc.getProperty() + "]. Supported types are [Integer, Long, Float, Double]");
        }
    }

    class WatchTask
    extends TimerTask {
        WatchDescriptor wDesc;
        Watch watch;
        Method accessor;

        WatchTask(Watch watch, Method accessor, WatchDescriptor wDesc) {
            this.watch = watch;
            this.accessor = accessor;
            this.wDesc = wDesc;
        }

        WatchDescriptor getWatchDescriptor() {
            return this.wDesc;
        }

        @Override
        public void run() {
            block2: {
                try {
                    Object value = this.accessor.invoke(WatchInjector.this.impl, null);
                    Double d = new Double(value.toString());
                    this.watch.addWatchRecord(new Calculable(this.watch.getId(), d.doubleValue(), System.currentTimeMillis()));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block2;
                    logger.log(Level.FINE, "Watch [" + this.watch.getId() + "], Invoking [" + this.accessor.getReturnType().getName() + "=" + this.accessor.getName() + "()]", e);
                }
            }
        }
    }
}

