/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client.cache.map;

import com.j_spaces.core.cache.AbstractCacheManager;
import com.j_spaces.javax.cache.Cache;
import com.j_spaces.javax.cache.EvictionStrategy;
import com.j_spaces.map.eviction.AbstractEvictionStrategy;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvictionCacheManager
extends AbstractCacheManager {
    private EvictionStrategy _evictionStrategy;
    private WeakReference<Cache> _cache;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");

    public EvictionCacheManager(EvictionStrategy evictionStrategy, Cache cache) {
        this.setCachePolicy(0);
        this._evictionStrategy = evictionStrategy;
        this._cache = new WeakReference<Cache>(cache);
    }

    public int evictBatch(int evictionQuota) {
        Cache cache = (Cache)this._cache.get();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.finest("Cache size before eviction=" + cache.size());
        }
        int size = this._evictionStrategy.evict(cache);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Cache size after eviction=" + cache.size() + " Evicted=" + size);
        }
        return size;
    }

    public void setEvictionQuota(int evictionQuota) {
        super.setEvictionQuota(evictionQuota);
        if (this._evictionStrategy instanceof AbstractEvictionStrategy) {
            ((AbstractEvictionStrategy)this._evictionStrategy).setBatchSize(evictionQuota);
        }
    }
}

