/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client.cache.map;

import com.gigaspaces.events.AbstractDataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.client.cache.SpaceCacheException;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.utils.SerializationUtil;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.MemoryManager;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.cache.AbstractCacheManager;
import com.j_spaces.core.client.CacheTimeoutException;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.cache.map.DummyCacheEntry;
import com.j_spaces.core.client.cache.map.EvictionCacheManager;
import com.j_spaces.javax.cache.CacheEntry;
import com.j_spaces.javax.cache.CacheException;
import com.j_spaces.javax.cache.CacheListener;
import com.j_spaces.javax.cache.EvictionStrategy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.kernel.weaklistener.WeakLeaseListener;
import com.j_spaces.kernel.weaklistener.WeakRemoteEventListener;
import com.j_spaces.map.AbstractMap;
import com.j_spaces.map.MapEntryFactory;
import com.j_spaces.map.SpaceMapEntry;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.transaction.Transaction;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;

public final class MapCache
extends AbstractMap
implements RemoteEventListener,
LeaseListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    public static final int DEFAULT_MAX_CONNECTION_RETRY = 3;
    private int _maxConnectionRetry = 3;
    private long _delayRetryTime = 5000L;
    private static final long DEFAULT_TEMPLATE_LEASE = 60000L;
    private final MemoryManager _memoryManager;
    private final SizeConcurrentHashMap<Object, CacheEntry> _cache;
    private final Set<CacheListener> _cacheListenerTable;
    private final int _updateMode;
    private final EvictionStrategy _evictionStrategy;
    private final String _cacheID;
    private final boolean _putFirst;
    private final int _sizeLimit;
    private final String _spaceURL;
    private final EventSessionConfig _sessionConfig;
    private AbstractDataEventSession _eventSession;

    public MapCache(IJSpace space, boolean isVersioned, int updateMode, EvictionStrategy evictionStrategy, boolean putFirst, int sizeLimit, int compression) throws RemoteException {
        super(space, -1L, null, compression, isVersioned);
        String containerName = space.getContainerName();
        String fullSpaceName = JSpaceUtilities.createFullSpaceName((String)containerName, (String)space.getName());
        if (JProperties.getSpaceProperties((String)fullSpaceName) == null) {
            SpaceConfig spProp = ((IRemoteJSpaceAdmin)((ISpaceProxy)space).getPrivilegedAdmin()).getConfig();
            JProperties.setSpaceProperties((String)fullSpaceName, (Properties)spProp.getDCacheProperties());
        }
        EvictionCacheManager cacheManager = new EvictionCacheManager(evictionStrategy, this);
        String dCacheSpaceName = fullSpaceName + "_DCache";
        this._memoryManager = new MemoryManager(dCacheSpaceName, containerName, (AbstractCacheManager)cacheManager, null, true);
        this._sizeLimit = sizeLimit;
        this._spaceURL = space.getFinderURL().getURL();
        this._cacheID = space instanceof IDirectSpaceProxy ? ((IDirectSpaceProxy)space).getRemoteJSpace().getUniqueID() : "";
        this._cache = new SizeConcurrentHashMap();
        this._cacheListenerTable = Collections.synchronizedSet(new HashSet());
        this._putFirst = putFirst;
        this._updateMode = updateMode;
        this._evictionStrategy = evictionStrategy;
        SpaceConfigReader configReader = new SpaceConfigReader(dCacheSpaceName);
        String findRetryConn = configReader.getSpaceProperty("dist-cache.retry-connections", null);
        String delayRetryConn = configReader.getSpaceProperty("dist-cache.delay-between-retries", null);
        this._maxConnectionRetry = findRetryConn != null ? Integer.parseInt(findRetryConn) : this._maxConnectionRetry;
        this._delayRetryTime = delayRetryConn != null ? Long.parseLong(delayRetryConn) : this._delayRetryTime;
        this._sessionConfig = new EventSessionConfig();
        this._sessionConfig.setAutoRenew(true, (LeaseListener)new WeakLeaseListener((LeaseListener)this));
        this._eventSession = this.initEventSession();
    }

    private AbstractDataEventSession initEventSession() throws RemoteException {
        SpaceMapEntry template = MapEntryFactory.create();
        WeakRemoteEventListener listener = new WeakRemoteEventListener((RemoteEventListener)this);
        NotifyActionType notifyType = NotifyActionType.NOTIFY_LEASE_EXPIRATION.or(NotifyActionType.NOTIFY_TAKE.or(NotifyActionType.NOTIFY_UPDATE));
        AbstractDataEventSession eventSession = (AbstractDataEventSession)DataEventSessionFactory.create((IJSpace)this._spaceProxy, (EventSessionConfig)this._sessionConfig);
        eventSession.addListener((Object)template, (RemoteEventListener)listener, 60000L, notifyType);
        return eventSession;
    }

    @Override
    protected Object internalPut(Object key, Object value, Transaction txn, long timeToLive, long timeout) {
        SpaceMapEntry newEnvelope = this.buildEnvelope(key, value, this._cacheID);
        try {
            Object oldValue;
            SpaceMapEntry oldEntry = (SpaceMapEntry)this._spaceProxy.update((Object)newEnvelope, txn, timeToLive, timeout, 4096);
            Object object = oldValue = oldEntry == null ? null : this.prepareValue(key, oldEntry);
            if (this._isVersioned) {
                this._entryInfos.setEntryVersion(value, key, newEnvelope.getVersion());
            }
            if (txn == null) {
                CacheEntry cacheEntry = this._evictionStrategy.createEntry(key, value, Long.MAX_VALUE, newEnvelope.getVersion());
                if (this._isVersioned) {
                    this.putLocalVersioned(newEnvelope, key, value, cacheEntry);
                } else {
                    this.putLocalNotVersioned(key, cacheEntry);
                }
                this._memoryManager.monitorMemoryUsage(true);
                if (!this._cacheListenerTable.isEmpty()) {
                    for (CacheListener listener : this._cacheListenerTable) {
                        listener.onPut(key);
                    }
                }
            } else {
                this.evict(key);
            }
            return oldValue;
        }
        catch (OperationTimeoutException e) {
            throw new CacheTimeoutException(key);
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to put value in space cache", (Throwable)e);
        }
    }

    private void putLocalVersioned(SpaceMapEntry newEnvelope, Object key, Object value, CacheEntry cacheEntry) {
        Object entry;
        VersionCacheEntry versionEntry = new VersionCacheEntry(newEnvelope.getVersion());
        boolean replaced = this._cache.replace(key, (Object)versionEntry, (Object)cacheEntry);
        if (!versionEntry.isChecked() && this._putFirst) {
            Object old;
            if (this._cache.size() >= this._sizeLimit) {
                this._evictionStrategy.evict(this);
            }
            if ((old = this._cache.putIfAbsent(key, (Object)cacheEntry)) != null) {
                replaced = this._cache.replace(key, (Object)versionEntry, (Object)cacheEntry);
            }
        }
        if (replaced && !((entry = versionEntry.getOldEntry()) instanceof DummyCacheEntry)) {
            this._evictionStrategy.discardEntry((CacheEntry)entry);
        }
    }

    private void putLocalNotVersioned(Object key, CacheEntry cacheEntry) {
        CacheEntry oldCacheEntry = this._putFirst ? (CacheEntry)this._cache.put(key, (Object)cacheEntry) : (CacheEntry)this._cache.replace(key, (Object)cacheEntry);
        if (oldCacheEntry != null) {
            if (!(oldCacheEntry instanceof DummyCacheEntry)) {
                this._evictionStrategy.discardEntry(oldCacheEntry);
            }
        } else if (this._putFirst && this._cache.size() >= this._sizeLimit) {
            this._evictionStrategy.evict(this);
        }
    }

    @Override
    public int size() {
        return this._cache.size();
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    @Override
    public void clear(boolean clearMaster) {
        if (clearMaster) {
            try {
                this._spaceProxy.clear((Object)MapEntryFactory.create(), null);
            }
            catch (Exception e) {
                throw new SpaceCacheException("Failed to clear space cache", (Throwable)e);
            }
        }
        this._cache.clear();
        this._evictionStrategy.clear();
        if (this._cacheListenerTable.size() != 0) {
            for (CacheListener listener : this._cacheListenerTable) {
                listener.onClear();
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this._cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        Collection collection = this._cache.values();
        ArrayList values = new ArrayList(this._cache.size());
        for (CacheEntry entry : collection) {
            if (entry instanceof DummyCacheEntry) continue;
            values.add(entry.getValue());
        }
        return values;
    }

    @Override
    public Set entrySet() {
        Collection collection = this._cache.values();
        HashSet<CacheEntry> set = new HashSet<CacheEntry>(this._cache.size());
        for (CacheEntry entry : collection) {
            if (entry instanceof DummyCacheEntry) continue;
            set.add(entry);
        }
        return set;
    }

    @Override
    public Set keySet() {
        Collection collection = this._cache.values();
        HashSet set = new HashSet(this._cache.size());
        for (CacheEntry entry : collection) {
            if (entry instanceof DummyCacheEntry) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    @Override
    public void addListener(CacheListener listener) {
        this._cacheListenerTable.add(listener);
    }

    @Override
    public boolean evict(Object key) {
        boolean evicted;
        boolean bl = evicted = this._cache.remove(key) != null;
        if (evicted && !this._cacheListenerTable.isEmpty()) {
            for (CacheListener listener : this._cacheListenerTable) {
                listener.onEvict(key);
            }
        }
        return evicted;
    }

    @Override
    public CacheEntry getCacheEntry(Object key) {
        return (CacheEntry)this._cache.get(key);
    }

    @Override
    public void load(Object key) throws CacheException {
        this.internalGet(key, null, Long.MAX_VALUE, 0);
    }

    @Override
    public void loadAll(Collection keys) throws CacheException {
        for (Object key : keys) {
            this.load(key);
        }
    }

    @Override
    public Object peek(Object key) {
        CacheEntry cacheEntry = (CacheEntry)this._cache.get(key);
        if (cacheEntry != null) {
            return cacheEntry.getValue();
        }
        return null;
    }

    @Override
    public void removeListener(CacheListener listener) {
        this._cacheListenerTable.remove(listener);
    }

    public void notify(RemoteEvent remoteEvent) throws UnknownEventException, RemoteException {
        try {
            this.consumeRequestCommand((EntryArrivedRemoteEvent)remoteEvent);
        }
        catch (ClassNotFoundException e) {
            throw new SpaceCacheException("Failed to consume data event in space cache", (Throwable)e);
        }
        catch (IOException e) {
            throw new SpaceCacheException("Failed to consume data event in space cache", (Throwable)e);
        }
        catch (UnusableEntryException e) {
            throw new SpaceCacheException("Failed to consume data event in space cache", (Throwable)e);
        }
    }

    private void consumeRequestCommand(EntryArrivedRemoteEvent commandEvent) throws ClassNotFoundException, IOException, UnusableEntryException {
        String cacheId;
        SpaceMapEntry entry = (SpaceMapEntry)commandEvent.getObject();
        if (commandEvent.getNotifyType() != 4 && commandEvent.getNotifyType() != 8 && this._cacheID.equals(cacheId = entry.getCacheId())) {
            return;
        }
        Object key = entry.getKey();
        if (this._updateMode == 2 && commandEvent.getNotifyType() == 2) {
            if (!this._cache.containsKey(key)) {
                return;
            }
            Object value = this.prepareValue(key, entry);
            CacheEntry cacheEntry = this._evictionStrategy.createEntry(key, value, Long.MAX_VALUE, entry.getVersion());
            if (this._isVersioned) {
                this._cache.replace(key, (Object)new VersionCacheEntry(entry.getVersion()), (Object)cacheEntry);
            } else {
                this._cache.replace(key, (Object)cacheEntry);
            }
        } else {
            this._cache.remove(key);
        }
    }

    @Override
    protected Object internalRemove(Object key, Transaction txn, long waitForResponse) {
        try {
            SpaceMapEntry template = this.buildEnvelope(key, null, null);
            boolean ifExists = txn != null;
            SpaceMapEntry entry = (SpaceMapEntry)this._spaceProxy.take((Object)template, txn, waitForResponse, 16384, ifExists);
            if (entry == null) {
                if (txn == null) {
                    Object var8_11 = null;
                    return var8_11;
                }
                throw new CacheTimeoutException(key);
            }
            Object object = this.prepareValue(key, entry);
            return object;
        }
        catch (EntryNotInSpaceException ex) {
            Object var6_9 = null;
            return var6_9;
        }
        catch (CacheTimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to remove value from space cache", (Throwable)e);
        }
        finally {
            CacheEntry cacheEntry = (CacheEntry)this._cache.remove(key);
            if (cacheEntry != null && !(cacheEntry instanceof DummyCacheEntry)) {
                this._evictionStrategy.discardEntry(cacheEntry);
                if (!this._cacheListenerTable.isEmpty()) {
                    for (CacheListener listener : this._cacheListenerTable) {
                        listener.onRemove(key);
                    }
                }
            }
        }
    }

    private Object getResult(CacheEntry obj) {
        this._evictionStrategy.touchEntry(obj);
        return obj.getValue();
    }

    @Override
    protected Object internalGet(Object key, Transaction txn, long waitForResponse, int readModifiers) {
        try {
            if (txn == null) {
                return this.getNotUnderTransaction(key, waitForResponse);
            }
            return this.getUnderTransaction(key, waitForResponse, txn);
        }
        catch (EntryNotInSpaceException e) {
            return null;
        }
        catch (CacheTimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to get value from space cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnderTransaction(Object key, long waitForResponse, Transaction txn) throws Exception {
        try {
            SpaceMapEntry template = MapEntryFactory.create((Object)key);
            this._memoryManager.monitorMemoryUsage(true);
            SpaceMapEntry entry = (SpaceMapEntry)this._spaceProxy.readIfExists((Object)template, txn, waitForResponse, 16384);
            if (entry == null) {
                throw new CacheTimeoutException(key);
            }
            Object object = this.prepareValue(key, entry);
            return object;
        }
        finally {
            this.evict(key);
        }
    }

    private Object prepareValue(Object key, SpaceMapEntry entry) throws ClassNotFoundException, IOException {
        Object value = entry.getValue();
        value = SerializationUtil.deSerializeFieldValue((Object)value, (StorageType)this._compression);
        if (this._isVersioned) {
            this._entryInfos.setEntryVersion(value, key, entry.getVersion());
        }
        return value;
    }

    private Object getNotUnderTransaction(Object key, long waitForResponse) throws Exception {
        DummyCacheEntry readMark = null;
        CacheEntry cacheEntry = (CacheEntry)this._cache.get(key);
        if (cacheEntry == null ? (cacheEntry = (CacheEntry)this._cache.putIfAbsent(key, (Object)(readMark = new DummyCacheEntry()))) != null && !(cacheEntry instanceof DummyCacheEntry) : !(cacheEntry instanceof DummyCacheEntry)) {
            return this.getResult(cacheEntry);
        }
        SpaceMapEntry template = MapEntryFactory.create((Object)key);
        this._memoryManager.monitorMemoryUsage(true);
        SpaceMapEntry entry = (SpaceMapEntry)this._spaceProxy.read((Object)template, (Transaction)null, waitForResponse, 16384);
        if (entry == null) {
            if (readMark != null) {
                this._cache.remove(key, (Object)readMark);
            }
            return null;
        }
        if (this._cache.size() >= this._sizeLimit) {
            this._evictionStrategy.evict(this);
        }
        Object value = this.prepareValue(key, entry);
        CacheEntry newCacheEntry = this._evictionStrategy.createEntry(key, value, Long.MAX_VALUE, entry.getVersion());
        if (!this._cache.replace(key, (Object)new VersionCacheEntry(entry.getVersion(), readMark), (Object)newCacheEntry)) {
            this._evictionStrategy.discardEntry(newCacheEntry);
        } else if (!this._cacheListenerTable.isEmpty()) {
            for (CacheListener listener : this._cacheListenerTable) {
                listener.onLoad(key);
            }
        }
        return value;
    }

    public void notify(LeaseRenewalEvent event) {
        this.log("LRM: Failed to renew lease.");
        try {
            try {
                this._eventSession.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reconnectToSpace();
            this._eventSession = this.initEventSession();
            this.clear();
            this.log("Reinitialized successfully.");
        }
        catch (Exception e) {
            this.log("Failed to initialize space", e);
        }
    }

    private void reconnectToSpace() throws InterruptedException, CacheException {
        boolean connected = false;
        int tryCount = 0;
        boolean isPinged = false;
        while (!connected && tryCount++ < this._maxConnectionRetry) {
            try {
                if (!isPinged) {
                    this._spaceProxy.ping();
                } else {
                    this._spaceProxy = (ISpaceProxy)SpaceFinder.find((String)this._spaceURL);
                }
                connected = true;
            }
            catch (FinderException e) {
                this.log("SpaceFinder Retry: " + tryCount, (Exception)((Object)e));
                Thread.sleep(this._delayRetryTime);
            }
            catch (RemoteException e) {
                tryCount = 0;
                isPinged = true;
                this.log("Ping failed to : " + this._spaceURL, e);
            }
        }
        if (!connected) {
            throw new CacheException("_remoteSpace [" + this._spaceURL + "] is not accessible. Giving up after trying " + this._maxConnectionRetry + " times.");
        }
    }

    protected void finalize() throws Throwable {
        this._memoryManager.close();
        if (this._eventSession != null) {
            this._eventSession.close();
        }
    }

    private static final class VersionCacheEntry
    extends DummyCacheEntry {
        private final int _version;
        private final DummyCacheEntry _mark;
        private Object _oldEntry;
        private boolean _checked = false;

        public VersionCacheEntry(int version) {
            this(version, null);
        }

        public VersionCacheEntry(int version, DummyCacheEntry mark) {
            this._version = version;
            this._mark = mark;
        }

        @Override
        public boolean equals(Object obj) {
            this._checked = true;
            this._oldEntry = obj;
            if (!(obj instanceof DummyCacheEntry)) {
                long version = ((CacheEntry)obj).getCacheEntryVersion();
                return (long)this._version > version;
            }
            return this._mark == obj;
        }

        public Object getOldEntry() {
            return this._oldEntry;
        }

        public boolean isChecked() {
            return this._checked;
        }
    }
}

