/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map;

import com.gigaspaces.internal.client.cache.ISpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheException;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.utils.SerializationUtil;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.CacheException;
import com.j_spaces.core.client.version.map.MapVersionTable;
import com.j_spaces.map.GSMapImpl;
import com.j_spaces.map.IMap;
import com.j_spaces.map.MapEntryFactory;
import com.j_spaces.map.SpaceMapEntry;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

public abstract class AbstractMap
implements IMap {
    public static final int NONE_COMPRESSION = 0;
    public static final int ZIP_COMPRESSION = 1;
    protected Transaction _transaction;
    protected long _timeToLive = Long.MAX_VALUE;
    protected long _timeout = 0L;
    protected ISpaceProxy _spaceProxy;
    protected final StorageType _compression;
    protected boolean _isVersioned;
    protected MapVersionTable _entryInfos;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");

    public AbstractMap(IJSpace space, long timeToLive, Transaction txn, int compression, boolean isVersioned) {
        this._spaceProxy = (ISpaceProxy)space;
        this._transaction = txn;
        this._timeToLive = timeToLive == -1L ? Long.MAX_VALUE : timeToLive;
        this._isVersioned = isVersioned;
        switch (compression) {
            case 1: {
                this._compression = StorageType.COMPRESSED;
                break;
            }
            default: {
                this._compression = StorageType.OBJECT;
            }
        }
        this.setVersioned(isVersioned);
    }

    @Override
    public final void setVersioned(boolean versioned) {
        this._isVersioned = versioned;
        this._spaceProxy.setOptimisticLocking(versioned);
        if (this._isVersioned && this._entryInfos == null) {
            this._entryInfos = MapVersionTable.getInstance();
        }
    }

    @Override
    public final boolean isVersioned() {
        return this._isVersioned;
    }

    @Override
    public final void setTimeToLive(long millisecond) {
        this._timeToLive = millisecond == -1L ? Long.MAX_VALUE : millisecond;
    }

    @Override
    public final long getTimeToLive() {
        return this._timeToLive;
    }

    @Override
    public final void setWaitForResponse(long timeout) {
        this._timeout = timeout;
    }

    @Override
    public final long getWaitForResponse() {
        return this._timeout;
    }

    protected abstract Object internalPut(Object var1, Object var2, Transaction var3, long var4, long var6) throws CacheException;

    protected abstract Object internalGet(Object var1, Transaction var2, long var3, int var5) throws CacheException;

    protected abstract Object internalRemove(Object var1, Transaction var2, long var3) throws CacheException;

    @Override
    public final Object put(Object key, Object value) {
        return this.put(key, value, this._timeToLive);
    }

    @Override
    public final Object put(Object key, Object value, long timeToLive) {
        return this.put(key, value, null, timeToLive);
    }

    @Override
    public Object put(Object key, Object value, long timeToLive, long timeout) {
        return this.put(key, value, null, timeToLive, timeout);
    }

    @Override
    public final Object put(Object key, Object value, Transaction txn, long timeToLive) {
        return this.put(key, value, txn, timeToLive, this._timeout);
    }

    @Override
    public final Object put(Object key, Object value, Transaction txn, long timeToLive, long timeout) {
        Object compressedValue;
        if (value == null || key == null) {
            throw new IllegalArgumentException("Key or value can not be null.");
        }
        if (timeToLive < 0L) {
            throw new IllegalArgumentException("timeToLive cannot be less than zero");
        }
        if (!(value instanceof Serializable)) {
            throw new SpaceCacheException("Error putting Object " + value.getClass() + " in the cache. " + value.getClass() + " must be serializable.");
        }
        try {
            compressedValue = SerializationUtil.serializeFieldValue((Object)value, (StorageType)this._compression);
        }
        catch (IOException e) {
            throw new SpaceCacheException("Failed to serialize value", (Throwable)e);
        }
        return this.internalPut(key, compressedValue, this.prepareTransaction(txn), timeToLive, timeout);
    }

    @Override
    public void putAll(Map map) {
        this.putAll(map, this.getTransaction(), this.getTimeToLive());
    }

    @Override
    public void putAll(Map map, Transaction txn, long timeToLive) {
        if (map instanceof GSMapImpl) {
            throw new IllegalArgumentException("Only java.util.Map or classes derived from java.util.Map are allowed.");
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.put(entry.getKey(), entry.getValue(), txn, timeToLive);
        }
    }

    @Override
    public Map getAll(Collection keys) throws com.j_spaces.javax.cache.CacheException {
        HashMap map = new HashMap(keys.size());
        for (Object key : keys) {
            map.put(key, this.get(key));
        }
        return map;
    }

    @Override
    public Object get(Object key) {
        return this.get(key, null, this._timeout, 0);
    }

    @Override
    public Object get(Object key, long waitForResponse) {
        return this.get(key, null, waitForResponse, 0);
    }

    @Override
    public Object get(Object key, Transaction txn, long waitForResponse, int readModifiers) {
        return this.internalGet(key, this.prepareTransaction(txn), waitForResponse, readModifiers);
    }

    @Override
    public int size() {
        try {
            return this._spaceProxy.count((Object)MapEntryFactory.create(), this._transaction);
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to get space cache size", (Throwable)e);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object remove(Object key) {
        return this.remove(key, null, this._timeout);
    }

    @Override
    public Object remove(Object key, long waitForResponse) {
        return this.remove(key, null, waitForResponse);
    }

    @Override
    public Object remove(Object key, Transaction txn, long waitForResponse) {
        return this.internalRemove(key, this.prepareTransaction(txn), waitForResponse);
    }

    @Override
    public final void setTransaction(Transaction transaction) {
        this._transaction = transaction;
    }

    @Override
    public final Transaction getTransaction() {
        return this._transaction;
    }

    @Override
    public void load(Object key) throws com.j_spaces.javax.cache.CacheException {
    }

    @Override
    public void loadAll(Collection keys) throws com.j_spaces.javax.cache.CacheException {
    }

    @Override
    public final IJSpace getMasterSpace() {
        if (this._spaceProxy instanceof ISpaceCache) {
            return ((ISpaceCache)this._spaceProxy).getRemoteSpace();
        }
        return this._spaceProxy;
    }

    @Override
    public final IJSpace getLocalSpace() {
        if (this._spaceProxy instanceof ISpaceCache) {
            return ((ISpaceCache)this._spaceProxy).getLocalSpace();
        }
        return null;
    }

    protected SpaceMapEntry buildEnvelope(Object key, Object value, String cacheID) {
        SpaceMapEntry envelope = MapEntryFactory.create((Object)key, (Object)value, (String)cacheID);
        if (this._isVersioned) {
            envelope.setVersion(this._entryInfos.getEntryVersion(value, key));
        }
        return envelope;
    }

    protected void log(String description, Exception ex) {
        if (_logger.isLoggable(Level.FINE)) {
            if (ex != null) {
                _logger.log(Level.FINE, this.toString() + " " + description + " | ", ex);
            } else {
                _logger.fine(description);
            }
        }
    }

    protected void log(String description) {
        this.log(description, null);
    }

    private Transaction prepareTransaction(Transaction txn) {
        return txn == null ? this._transaction : txn;
    }
}

