/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map;

import com.gigaspaces.internal.client.cache.SpaceCacheException;
import com.gigaspaces.internal.client.spaceproxy.AbstractSpaceProxy;
import com.gigaspaces.internal.client.utils.SerializationUtil;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.CacheException;
import com.j_spaces.core.client.CacheTimeoutException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.javax.cache.CacheEntry;
import com.j_spaces.javax.cache.CacheListener;
import com.j_spaces.map.AbstractMap;
import com.j_spaces.map.MapEntryFactory;
import com.j_spaces.map.SpaceMapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jini.core.transaction.Transaction;

public final class GSMapImpl
extends AbstractMap {
    protected GSMapImpl(IJSpace space, long timeToLive, Transaction txn, int compress) {
        super(space, timeToLive, txn, compress, space.isOptimisticLockingEnabled());
        MapEntryFactory.initialize((IJSpace)space);
    }

    public GSMapImpl(IJSpace space) {
        this(space, -1L, null, 0);
    }

    public GSMapImpl(IJSpace space, long timeToLive) {
        this(space, timeToLive, null, 0);
    }

    public GSMapImpl(IJSpace space, int compress) {
        this(space, Long.MAX_VALUE, null, compress);
    }

    public GSMapImpl(IJSpace space, Transaction txn) {
        this(space, Long.MAX_VALUE, txn, 0);
    }

    @Override
    protected Object internalPut(Object key, Object value, Transaction txn, long timeToLive, long timeout) throws CacheException {
        SpaceMapEntry newEnvelope = this.buildEnvelope(key, value, null);
        try {
            SpaceMapEntry oldEntry = (SpaceMapEntry)this._spaceProxy.update((Object)newEnvelope, txn, timeToLive, timeout, 4096);
            Object envValue = null;
            if (oldEntry != null) {
                envValue = oldEntry.getValue();
                if (this._isVersioned) {
                    this._entryInfos.setEntryVersion(envValue, key, oldEntry.getVersion());
                }
            }
            if (this._isVersioned) {
                this._entryInfos.setEntryVersion(value, key, newEnvelope.getVersion());
            }
            return envValue;
        }
        catch (OperationTimeoutException e) {
            throw new CacheTimeoutException(key);
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to put value in space cache", (Throwable)e);
        }
    }

    @Override
    protected Object internalRemove(Object key, Transaction txn, long waitForResponse) throws CacheException {
        return this.internalGet(key, txn, waitForResponse, 0, true);
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            SpaceMapEntry template = MapEntryFactory.create((Object)key);
            return this._spaceProxy.read((Object)template, this._transaction, 0L, 16384) != null;
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed on check if space cache contains key", (Throwable)e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            Object compressedValue = SerializationUtil.serializeFieldValue((Object)value, (StorageType)this._compression);
            SpaceMapEntry template = MapEntryFactory.create(null, (Object)compressedValue);
            return this._spaceProxy.count((Object)template, this._transaction) > 0;
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed on check if space cache contains value", (Throwable)e);
        }
    }

    @Override
    protected Object internalGet(Object key, Transaction txn, long waitForResponse, int readModifiers) {
        return this.internalGet(key, txn, waitForResponse, readModifiers, false);
    }

    protected Object internalGet(Object key, Transaction txn, long waitForResponse, int readModifiers, boolean isRemove) {
        try {
            SpaceMapEntry template = MapEntryFactory.create((Object)key);
            boolean ifExists = txn != null;
            SpaceMapEntry envelopeObj = isRemove ? (SpaceMapEntry)this._spaceProxy.take((Object)template, txn, waitForResponse, 16384, ifExists) : (SpaceMapEntry)this._spaceProxy.read((Object)template, txn, waitForResponse, readModifiers | 0x4000, ifExists);
            if (envelopeObj == null) {
                if (txn == null) {
                    return null;
                }
                throw new CacheTimeoutException(key);
            }
            Object envValue = envelopeObj.getValue();
            envValue = SerializationUtil.deSerializeFieldValue((Object)envValue, (StorageType)this._compression);
            if (this._isVersioned) {
                this._entryInfos.setEntryVersion(envValue, key, envelopeObj.getVersion());
            }
            return envValue;
        }
        catch (EntryNotInSpaceException ex) {
            return null;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to get value from space cache", (Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    @Override
    public void clear(boolean clearMaster) {
        try {
            SpaceMapEntry template = MapEntryFactory.create();
            if (this._spaceProxy instanceof AbstractSpaceProxy && ((AbstractSpaceProxy)this._spaceProxy).isCacheContainer()) {
                ((AbstractSpaceProxy)this._spaceProxy).getLocalSpace().clear((Object)template, null);
                if (clearMaster) {
                    ((AbstractSpaceProxy)this._spaceProxy).getRemoteSpace().clear((Object)template, null);
                }
            } else {
                this._spaceProxy.clear((Object)template, null);
            }
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to clear space cache", (Throwable)e);
        }
    }

    @Override
    public Collection values() {
        SpaceMapEntry[] entries;
        SpaceMapEntry keyEnv = MapEntryFactory.create();
        try {
            entries = (SpaceMapEntry[])this._spaceProxy.readMultiple((Object)keyEnv, this._transaction, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to read cache entries from remote space", (Throwable)e);
        }
        ArrayList<Object> values = new ArrayList<Object>(entries.length);
        for (SpaceMapEntry entry : entries) {
            values.add(entry.getValue());
        }
        return values;
    }

    @Override
    public Set entrySet() {
        SpaceMapEntry[] entries;
        SpaceMapEntry keyEnv = MapEntryFactory.create();
        try {
            entries = (SpaceMapEntry[])this._spaceProxy.readMultiple((Object)keyEnv, this._transaction, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to read cache entries from remote space", (Throwable)e);
        }
        HashSet<SimpleEntry> entriesSet = new HashSet<SimpleEntry>();
        for (SpaceMapEntry entry : entries) {
            SimpleEntry mapEntry = new SimpleEntry(entry.getKey(), entry.getValue(), entry.getVersion());
            entriesSet.add(mapEntry);
        }
        return entriesSet;
    }

    @Override
    public Set keySet() {
        SpaceMapEntry[] entries;
        SpaceMapEntry keyEnv = MapEntryFactory.create();
        try {
            entries = (SpaceMapEntry[])this._spaceProxy.readMultiple((Object)keyEnv, this._transaction, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new SpaceCacheException("Failed to read cache entries from remote space", (Throwable)e);
        }
        HashSet<Object> keys = new HashSet<Object>();
        for (SpaceMapEntry entry : entries) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public final void addListener(CacheListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean evict(Object key) {
        return true;
    }

    @Override
    public final CacheEntry getCacheEntry(Object key) {
        Object value = this.get(key);
        long version = this._entryInfos.getEntryVersion(value, key);
        return new SimpleEntry(key, value, version);
    }

    @Override
    public Object peek(Object key) {
        return this.get(key);
    }

    @Override
    public void removeListener(CacheListener listener) {
        throw new UnsupportedOperationException();
    }

    private static class SimpleEntry
    implements CacheEntry {
        private Object _key;
        private Object _value;
        private long _version;

        public SimpleEntry(Object key, Object value, long version) {
            this._key = key;
            this._value = value;
            this._version = version;
        }

        @Override
        public Object getKey() {
            return this._key;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this._key, e.getKey()) && SimpleEntry.eq(this._value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
        }

        public String toString() {
            return this._key + "=" + this._value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public long getCacheEntryVersion() {
            return this._version;
        }
    }
}

