/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.j_spaces.core.Constants;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceInitializationException;
import com.j_spaces.core.client.cache.map.MapCache;
import com.j_spaces.javax.cache.EvictionStrategy;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.map.GSMapImpl;
import com.j_spaces.map.IMap;
import com.j_spaces.map.eviction.AbstractEvictionStrategy;
import com.j_spaces.map.eviction.NoneEvictionStrategy;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapFactory {
    public static IMap createMapWithCache(IJSpace space, Integer updateMode) throws FinderException {
        SpaceConfigReader dcacheConfigReader = MapFactory.getDCacheConfigReader(space);
        boolean putFirst = dcacheConfigReader.getBooleanSpaceProperty("dist-cache.put-first", "true");
        int compression = dcacheConfigReader.getIntSpaceProperty("dist-cache.compression", "0");
        boolean versioned = dcacheConfigReader.getBooleanSpaceProperty("dist-cache.versioned", "false");
        int sizeLimit = dcacheConfigReader.getIntSpaceProperty("engine.cache_size", "100000");
        EvictionStrategy evictionStrategy = MapFactory.loadEvictionStrategy(dcacheConfigReader);
        if (updateMode == null) {
            updateMode = dcacheConfigReader.getIntSpaceProperty("dist-cache.update-mode", Constants.DCache.UPDATE_MODE_DEFUALT);
        }
        space.setOptimisticLocking(versioned);
        try {
            return new MapCache(space, versioned, updateMode, evictionStrategy, putFirst, sizeLimit, compression);
        }
        catch (RemoteException e) {
            throw new FinderException("Failed to create MapCache", (Throwable)e);
        }
    }

    public static IMap createMap(IJSpace space) throws FinderException {
        SpaceConfigReader dCacheConfigReader = MapFactory.getDCacheConfigReader(space);
        int compression = dCacheConfigReader.getIntSpaceProperty("dist-cache.compression", "0");
        return new GSMapImpl(space, compression);
    }

    private static EvictionStrategy loadEvictionStrategy(SpaceConfigReader dcacheConfigReader) throws FinderException {
        String evictionStrategyName = dcacheConfigReader.getSpaceProperty("dist-cache.eviction-strategy", "com.j_spaces.map.eviction.FIFOEvictionStrategy");
        try {
            EvictionStrategy evictionStrategy = (EvictionStrategy)ClassLoaderHelper.loadClass((String)evictionStrategyName).newInstance();
            if (evictionStrategy instanceof AbstractEvictionStrategy) {
                int batchSize = dcacheConfigReader.getIntSpaceProperty("engine.memory_usage.eviction_batch_size", "500");
                ((AbstractEvictionStrategy)evictionStrategy).setBatchSize(batchSize);
            }
            return evictionStrategy;
        }
        catch (ClassNotFoundException e) {
            Logger logger = Logger.getLogger("com.gigaspaces.common.spacefinder");
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Failed to find eviction strategy implementation using NoneEvictionStrategy.", e);
            }
            return new NoneEvictionStrategy();
        }
        catch (InstantiationException e) {
            throw new FinderException("Failed to create eviction strategy: " + evictionStrategyName, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FinderException("Failed to create eviction strategy: " + evictionStrategyName, (Throwable)e);
        }
    }

    private static SpaceConfigReader getDCacheConfigReader(IJSpace space) throws FinderException {
        try {
            return JProperties.loadDCacheConfig((ISpaceProxy)((ISpaceProxy)space), (Properties)space.getFinderURL().getCustomProperties(), (String)"_DCache");
        }
        catch (SpaceInitializationException e) {
            throw new FinderException("Failed to initialize map configuration", (Throwable)e);
        }
    }
}

