/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map.eviction;

import com.j_spaces.core.client.cache.map.BaseCacheEntry;
import com.j_spaces.javax.cache.Cache;
import com.j_spaces.javax.cache.CacheEntry;
import com.j_spaces.map.eviction.AbstractEvictionStrategy;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;

public class LFUEvictionStrategy
extends AbstractEvictionStrategy {
    private final TreeSet<FUCacheEntry> _sorted = new TreeSet();

    @Override
    public synchronized void clear() {
        this._sorted.clear();
    }

    @Override
    public synchronized void discardEntry(CacheEntry entry) {
        this._sorted.remove(entry);
    }

    @Override
    public synchronized int evict(Cache cache) {
        int evicted = 0;
        for (int i = 0; i < this._batchSize && this._sorted.size() > 0; ++i) {
            FUCacheEntry entry = this._sorted.first();
            if (entry == null) {
                return evicted;
            }
            this._sorted.remove(entry);
            if (!cache.evict(entry.getKey())) continue;
            ++evicted;
        }
        return evicted;
    }

    @Override
    public synchronized void touchEntry(CacheEntry entry) {
        if (this._sorted.remove(entry)) {
            FUCacheEntry e = (FUCacheEntry)entry;
            e.touch();
            this._sorted.add(e);
        }
    }

    @Override
    public synchronized CacheEntry createEntry(Object key, Object value, long ttl, int version) {
        FUCacheEntry entry = new FUCacheEntry(key, value, ttl, version);
        this._sorted.add(entry);
        return entry;
    }

    private static class FUCacheEntry
    extends BaseCacheEntry
    implements Comparable<FUCacheEntry> {
        private volatile int _touchCounter = 0;
        private static final AtomicInteger _nextID = new AtomicInteger();
        private final int _id = _nextID.getAndIncrement();

        public FUCacheEntry(Object key, Object value, long timeToLive, int version) {
            super(key, value, timeToLive, version);
        }

        public void touch() {
            int count = this._touchCounter;
            this._touchCounter = count + 1;
        }

        @Override
        public int compareTo(FUCacheEntry entry) {
            if (entry == this) {
                return 0;
            }
            int diff = this._touchCounter - entry._touchCounter;
            if (diff == 0) {
                return this._id - entry._id;
            }
            return diff;
        }
    }
}

