/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.map.eviction;

import com.j_spaces.core.client.cache.map.BaseCacheEntry;
import com.j_spaces.javax.cache.Cache;
import com.j_spaces.javax.cache.CacheEntry;
import com.j_spaces.kernel.Sizeof;
import com.j_spaces.map.eviction.AbstractEvictionStrategy;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class SizeEvictionStrategy
extends AbstractEvictionStrategy {
    SortedSet<SizeBaseCacheEntry> _entries = Collections.synchronizedSortedSet(new TreeSet());

    @Override
    public void clear() {
        this._entries.clear();
    }

    @Override
    public void discardEntry(CacheEntry entry) {
        this._entries.remove(entry);
    }

    @Override
    public int evict(Cache cache) {
        int evicted = 0;
        for (int i = 0; i < this._batchSize; ++i) {
            SizeBaseCacheEntry entry = null;
            try {
                entry = this._entries.last();
            }
            catch (NoSuchElementException e) {
                return evicted;
            }
            this._entries.remove(entry);
            if (!cache.evict(entry.getKey())) continue;
            ++evicted;
        }
        return evicted;
    }

    @Override
    public void touchEntry(CacheEntry entry) {
    }

    @Override
    public CacheEntry createEntry(Object key, Object value, long ttl, int version) {
        SizeBaseCacheEntry entry = new SizeBaseCacheEntry(key, value, ttl, version);
        this._entries.add(entry);
        return entry;
    }

    private static final class SizeBaseCacheEntry
    extends BaseCacheEntry
    implements Comparable<SizeBaseCacheEntry> {
        private final int _size;

        public SizeBaseCacheEntry(Object key, Object value, long timeToLive, int version) {
            super(key, value, timeToLive, version);
            this._size = Sizeof.sizeof((Object)value);
        }

        @Override
        public int compareTo(SizeBaseCacheEntry o) {
            int diff = this._size - o._size;
            if (diff == 0 && this != o) {
                diff = this.hashCode() - o.hashCode();
            }
            return diff;
        }
    }
}

