/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.DelegatingDnsResolver;
import com.amazonaws.http.IdleConnectionReaper;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpParams;

class ConnectionManagerFactory {
    ConnectionManagerFactory() {
    }

    public static PoolingClientConnectionManager createPoolingClientConnManager(ClientConfiguration config, HttpParams httpClientParams, SSLSocketFactory socketFactory) {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(ConnectionManagerFactory.createSchemeRegistry(socketFactory), config.getConnectionTTL(), TimeUnit.MILLISECONDS, (DnsResolver)new DelegatingDnsResolver(config.getDnsResolver()));
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        connectionManager.setMaxTotal(config.getMaxConnections());
        if (config.useReaper()) {
            IdleConnectionReaper.registerConnectionManager((ClientConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    private static SchemeRegistry createSchemeRegistry(SSLSocketFactory socketFactory) {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
        return registry;
    }
}

