/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.eventcontainer;

import com.gigaspaces.client.WriteModifiers;
import java.util.Properties;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageDispatcher;
import org.openspaces.core.GigaSpace;
import org.openspaces.esb.mule.eventcontainer.OpenSpacesConnector;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class OpenSpacesMessageDispatcher
extends AbstractMessageDispatcher {
    private static final String ENDPOINT_PARAM_WRITE_LEASE = "writeLease";
    private static final String ENDPOINT_PARAM_UPDATE_OR_WRITE = "updateOrWrite";
    private static final String ENDPOINT_PARAM_UPDATE_TIMEOUT = "updateTimeout";
    private GigaSpace gigaSpace;
    private long writeLease = Long.MAX_VALUE;
    private boolean updateOrWrite = true;
    private long updateTimeout = 0L;

    public OpenSpacesMessageDispatcher(OutboundEndpoint endpoint) throws CreateException {
        super(endpoint);
        ApplicationContext applicationContext = ((OpenSpacesConnector)this.getConnector()).getApplicationContext();
        if (applicationContext == null) {
            throw new CreateException(CoreMessages.connectorWithProtocolNotRegistered((String)this.connector.getProtocol()), (Object)this);
        }
        this.initWritingAttributes((ImmutableEndpoint)endpoint);
        String spaceId = endpoint.getEndpointURI().getPath();
        if (!StringUtils.hasLength((String)spaceId)) {
            spaceId = endpoint.getEndpointURI().getAddress();
        } else if (spaceId.startsWith("/")) {
            spaceId = spaceId.substring(1);
        }
        this.gigaSpace = (GigaSpace)applicationContext.getBean(spaceId);
    }

    private void initWritingAttributes(ImmutableEndpoint endpoint) {
        Properties params = endpoint.getEndpointURI().getParams();
        if (params != null) {
            try {
                String updateTimeoutStr;
                String updateOrWriteStr;
                String writeLeaseStr = (String)params.get(ENDPOINT_PARAM_WRITE_LEASE);
                if (writeLeaseStr != null) {
                    this.writeLease = Long.valueOf(writeLeaseStr);
                }
                if ((updateOrWriteStr = (String)params.get(ENDPOINT_PARAM_UPDATE_OR_WRITE)) != null) {
                    this.updateOrWrite = Boolean.valueOf(updateOrWriteStr);
                }
                if ((updateTimeoutStr = (String)params.get(ENDPOINT_PARAM_UPDATE_TIMEOUT)) != null) {
                    this.updateTimeout = Long.valueOf(updateTimeoutStr);
                }
            }
            catch (NumberFormatException e) {
                throw new MuleRuntimeException(CoreMessages.failedToCreateConnectorFromUri((EndpointURI)endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void doDispose() {
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        this.doSend(event);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        Object payload = event.getMessage().getPayload();
        if (payload != null) {
            WriteModifiers modifiers;
            WriteModifiers writeModifiers = modifiers = this.updateOrWrite ? WriteModifiers.UPDATE_OR_WRITE : WriteModifiers.WRITE_ONLY;
            if (payload instanceof Object[]) {
                this.gigaSpace.writeMultiple((Object[])payload, this.writeLease, modifiers);
            } else {
                this.gigaSpace.write(payload, this.writeLease, this.updateTimeout, modifiers);
            }
        }
        return null;
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected MuleMessage doReceive(long timeout) throws Exception {
        return null;
    }
}

