/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.eventcontainer;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.resource.spi.work.Work;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractReceiverWorker;
import org.openspaces.core.GigaSpace;
import org.openspaces.esb.mule.eventcontainer.OpenSpacesConnector;
import org.openspaces.events.AbstractEventListenerContainer;
import org.openspaces.events.SpaceDataEventListener;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;

public class OpenSpacesMessageReceiver
extends AbstractMessageReceiver
implements SpaceDataEventListener {
    private static final String ENDPOINT_PARAM_WORK_MANAGER = "workManager";
    private static final MessagingExceptionHandler exceptionHandler = new DefaultMessagingExceptionStrategy();
    private AbstractEventListenerContainer eventListenerContainer;
    private boolean workManager = false;
    private volatile boolean disposed = false;

    public OpenSpacesMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.init(connector, endpoint);
    }

    public OpenSpacesMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, (FlowConstruct)service, endpoint);
        this.init(connector, endpoint);
    }

    private void init(Connector connector, InboundEndpoint endpoint) throws CreateException {
        ApplicationContext applicationContext = ((OpenSpacesConnector)connector).getApplicationContext();
        if (applicationContext == null) {
            throw new CreateException(CoreMessages.connectorWithProtocolNotRegistered((String)connector.getProtocol()), (Object)this);
        }
        this.initWritingAttributes((ImmutableEndpoint)endpoint);
        String eventListenerContainerName = endpoint.getEndpointURI().getAddress();
        this.eventListenerContainer = (AbstractEventListenerContainer)applicationContext.getBean(eventListenerContainerName);
        this.eventListenerContainer.setEventListener((SpaceDataEventListener)this);
    }

    private void initWritingAttributes(ImmutableEndpoint endpoint) {
        Properties params = endpoint.getEndpointURI().getParams();
        if (params != null) {
            try {
                String workManager = (String)params.get(ENDPOINT_PARAM_WORK_MANAGER);
                if (workManager != null) {
                    this.workManager = Boolean.valueOf(workManager);
                }
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.failedToCreateConnectorFromUri((EndpointURI)endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    public void onEvent(final Object data, final GigaSpace gigaSpace, final TransactionStatus txStatus, final Object source) {
        if (txStatus != null) {
            ExecutionTemplate executionTemplate = this.createExecutionTemplate();
            try {
                if (this.disposed) {
                    txStatus.setRollbackOnly();
                    return;
                }
                executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                    public MuleEvent process() throws Exception {
                        return OpenSpacesMessageReceiver.this.doReceiveEvent(data, gigaSpace, txStatus, source);
                    }
                });
            }
            catch (Exception e) {
                txStatus.setRollbackOnly();
            }
        } else {
            if (this.disposed) {
                return;
            }
            try {
                this.doReceiveEvent(data, gigaSpace, txStatus, source);
            }
            catch (Exception e) {
                this.getConnector().getMuleContext().handleException(e);
            }
        }
    }

    protected MuleEvent doReceiveEvent(Object data, GigaSpace gigaSpace, TransactionStatus txStatus, Object source) throws Exception {
        if (!this.workManager) {
            MuleMessage message = this.createMuleMessage(data, this.endpoint.getEncoding());
            MuleEvent muleEvent = this.routeMessage(message);
            if (this.endpoint.getExchangePattern().hasResponse()) {
                MuleMessage responseMessage = muleEvent.getMessage();
                Object payload = responseMessage.getPayload();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(this.getEndpointURI() + " sending response to client  " + payload));
                }
                OpenSpacesMessageReceiver.writeResponseToSpace(gigaSpace, payload);
            }
            return muleEvent;
        }
        this.getWorkManager().scheduleWork((Work)new GigaSpaceWorker(data, this, gigaSpace));
        return null;
    }

    private static void writeResponseToSpace(GigaSpace gigaSpace, Object payload) {
        if (payload != null) {
            if (payload instanceof Object[]) {
                Object[] payloadArr = (Object[])payload;
                gigaSpace.writeMultiple(payloadArr);
            } else {
                gigaSpace.write(payload);
            }
        }
    }

    protected void doStart() throws MuleException {
        this.eventListenerContainer.start();
    }

    protected void doDisconnect() throws Exception {
        this.eventListenerContainer.setEventListener(null);
    }

    protected void doStop() throws MuleException {
        this.eventListenerContainer.stop();
    }

    protected void doConnect() throws Exception {
    }

    protected void doDispose() {
        this.disposed = true;
    }

    protected static class GigaSpaceWorker
    extends AbstractReceiverWorker {
        private final GigaSpace gigaSpace;

        public GigaSpaceWorker(Object message, OpenSpacesMessageReceiver receiver, GigaSpace gigaSpace) {
            super(new ArrayList(1), (AbstractMessageReceiver)receiver);
            this.gigaSpace = gigaSpace;
            this.messages.add(message);
        }

        protected void bindTransaction(Transaction tx) throws TransactionException {
        }

        protected void handleResults(List messages) throws Exception {
            if (this.endpoint.getExchangePattern().hasResponse()) {
                for (Object message : messages) {
                    MuleMessage responseMessage = (MuleMessage)message;
                    Object payload = responseMessage.getPayload();
                    OpenSpacesMessageReceiver.writeResponseToSpace(this.gigaSpace, payload);
                }
            }
        }
    }
}

