/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.pu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextFactory;
import org.mule.config.ConfigResource;
import org.mule.config.spring.OptionalObjectsController;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;

public class OpenSpacesMuleContextLoader
implements ApplicationContextAware,
InitializingBean,
DisposableBean,
ApplicationListener,
ServiceDetailsProvider,
ServiceMonitorsProvider {
    private static final String DEFAULT_LOCATION = "META-INF/spring/mule.xml";
    private String location;
    private ApplicationContext applicationContext;
    private MuleContextFactory muleContextFactory;
    private AbstractApplicationContext muleApplicationContext;
    private MuleContext muleContext;
    private volatile boolean contextCreated = false;

    public void setLocation(String location) {
        this.location = location;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.location == null) {
            this.location = DEFAULT_LOCATION;
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && !this.contextCreated) {
            this.contextCreated = true;
            try {
                this.muleContextFactory = new DefaultMuleContextFactory();
                SpringXmlConfigurationBuilder muleXmlConfigurationBuilder = new SpringXmlConfigurationBuilder(this.location){

                    protected ApplicationContext doCreateApplicationContext(MuleContext muleContext, ConfigResource[] configResources, OptionalObjectsController optionalObjectsController) {
                        AbstractApplicationContext context = (AbstractApplicationContext)super.doCreateApplicationContext(muleContext, configResources, optionalObjectsController);
                        context.setParent(this.applicationContext);
                        OpenSpacesMuleContextLoader.this.muleApplicationContext = context;
                        return context;
                    }
                };
                muleXmlConfigurationBuilder.setParentContext(this.applicationContext);
                this.muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)muleXmlConfigurationBuilder);
                this.muleContext.start();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start mule [" + this.location + "]", e);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.muleContext != null) {
            try {
                this.muleApplicationContext.setParent(null);
                this.muleContext.dispose();
            }
            finally {
                this.muleContext = null;
                this.muleApplicationContext = null;
            }
        }
    }

    public ServiceDetails[] getServicesDetails() {
        ArrayList<ServiceDetails> serviceDetails = new ArrayList<ServiceDetails>();
        if (this.muleApplicationContext != null) {
            Map map = this.muleApplicationContext.getBeansOfType(ServiceDetailsProvider.class);
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                ServiceDetails[] details = ((ServiceDetailsProvider)it.next()).getServicesDetails();
                if (details == null) continue;
                for (ServiceDetails detail : details) {
                    serviceDetails.add(detail);
                }
            }
        }
        return serviceDetails.toArray(new ServiceDetails[serviceDetails.size()]);
    }

    public ServiceMonitors[] getServicesMonitors() {
        ArrayList<ServiceMonitors> serviceMonitors = new ArrayList<ServiceMonitors>();
        if (this.muleApplicationContext != null) {
            Map map = this.muleApplicationContext.getBeansOfType(ServiceMonitorsProvider.class);
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                ServiceMonitors[] monitors = ((ServiceMonitorsProvider)it.next()).getServicesMonitors();
                if (monitors == null) continue;
                for (ServiceMonitors monitor : monitors) {
                    serviceMonitors.add(monitor);
                }
            }
        }
        return serviceMonitors.toArray(new ServiceMonitors[serviceMonitors.size()]);
    }
}

