/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.queue;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.MessageReceiver;
import org.mule.endpoint.DynamicURIInboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.AbstractConnector;
import org.openspaces.core.GigaSpace;
import org.openspaces.esb.mule.queue.OpenSpacesFifoQueueObject;
import org.openspaces.esb.mule.queue.OpenSpacesQueueMessageReceiver;
import org.openspaces.esb.mule.queue.OpenSpacesQueueObject;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class OpenSpacesQueueConnector
extends AbstractConnector
implements ApplicationContextAware {
    public static final String OS_QUEUE = "os-queue";
    private String gigaSpaceRef;
    private boolean fifo = false;
    private boolean persistent = false;
    private long timeout = 1000L;
    private Integer batchSize;
    private ApplicationContext applicationContext;
    private GigaSpace gigaSpace;

    public OpenSpacesQueueConnector(MuleContext context) {
        super(context);
    }

    public String getProtocol() {
        return OS_QUEUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setGigaSpace(String gigaSpaceRef) {
        this.gigaSpaceRef = gigaSpaceRef;
    }

    public String getGigaSpace() {
        return this.gigaSpaceRef;
    }

    public boolean isFifo() {
        return this.fifo;
    }

    public void setFifo(boolean fifo) {
        this.fifo = fifo;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.timeout = timeout;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        if (batchSize < 0) {
            throw new IllegalArgumentException("batchSize cannot be negative");
        }
        this.batchSize = batchSize;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.batchSize == null) {
            int maxThreads = this.getReceiverThreadingProfile().getMaxThreadsActive();
            this.batchSize = Math.max(1, maxThreads / 2 - 1);
        }
    }

    protected void doDispose() {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doConnect() throws Exception {
        if (this.gigaSpaceRef == null) {
            String[] beansNames = this.applicationContext.getBeanNamesForType(GigaSpace.class);
            if (beansNames == null || beansNames.length != 1) throw new RuntimeException("No GigaSpace ref is configured, and more than one GigaSpace bean is configured");
            this.gigaSpace = (GigaSpace)this.applicationContext.getBean(beansNames[0]);
            return;
        } else {
            this.gigaSpace = (GigaSpace)this.applicationContext.getBean(this.gigaSpaceRef);
        }
    }

    protected void doDisconnect() throws Exception {
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public GigaSpace getGigaSpaceObj() {
        return this.gigaSpace;
    }

    OpenSpacesQueueMessageReceiver getReceiver(EndpointURI endpointUri) throws EndpointException {
        return (OpenSpacesQueueMessageReceiver)this.getReceiverByEndpoint(endpointUri);
    }

    protected MessageReceiver getReceiverByEndpoint(EndpointURI endpointUri) throws EndpointException {
        MessageReceiver receiver2;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up os-queue receiver for address: " + endpointUri.toString()));
        }
        if ((receiver2 = (MessageReceiver)this.receivers.get(endpointUri.getAddress())) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found exact receiver match on endpointUri: " + endpointUri));
            }
            return receiver2;
        }
        for (MessageReceiver receiver2 : this.receivers.values()) {
            String filterAddress = receiver2.getEndpointURI().getAddress();
            WildcardFilter filter = new WildcardFilter(filterAddress);
            if (!filter.accept((Object)endpointUri.getAddress())) continue;
            InboundEndpoint endpoint = receiver2.getEndpoint();
            MuleEndpointURI newEndpointURI = new MuleEndpointURI(endpointUri, filterAddress);
            receiver2.setEndpoint((InboundEndpoint)new DynamicURIInboundEndpoint(endpoint, (EndpointURI)newEndpointURI));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found receiver match on endpointUri: " + receiver2.getEndpointURI() + " against " + endpointUri));
            }
            return receiver2;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No receiver found for endpointUri: " + endpointUri));
        }
        return null;
    }

    public OpenSpacesQueueObject newQueueTemplate(String queueName) {
        OpenSpacesQueueObject queueObject = this.isFifo() ? new OpenSpacesFifoQueueObject() : new OpenSpacesQueueObject();
        queueObject.setPersistent(this.isPersistent());
        queueObject.setEndpointURI(queueName);
        return queueObject;
    }

    public OpenSpacesQueueObject newQueueEntry(String queueName) {
        OpenSpacesQueueObject queueObject = this.isFifo() ? new OpenSpacesFifoQueueObject() : new OpenSpacesQueueObject();
        queueObject.setPersistent(this.isPersistent());
        queueObject.setEndpointURI(queueName);
        return queueObject;
    }

    public boolean isResponseEnabled() {
        return true;
    }
}

