/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.queue;

import com.gigaspaces.document.DocumentProperties;
import java.io.IOException;
import java.util.UUID;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.transport.AbstractMessageDispatcher;
import org.openspaces.esb.mule.queue.OpenSpacesQueueConnector;
import org.openspaces.esb.mule.queue.OpenSpacesQueueMessageReceiver;
import org.openspaces.esb.mule.queue.OpenSpacesQueueObject;

public class OpenSpacesQueueMessageDispatcher
extends AbstractMessageDispatcher {
    public static final String DEFAULT_RESPONSE_QUEUE = "_response_queue";
    private final OpenSpacesQueueConnector connector;

    public OpenSpacesQueueMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (OpenSpacesQueueConnector)endpoint.getConnector();
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        this.dispatchMessage(event, false);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        return this.dispatchMessage(event, true);
    }

    private MuleMessage dispatchMessage(final MuleEvent event, boolean doSend) throws Exception {
        final EndpointURI endpointUri = this.endpoint.getEndpointURI();
        if (endpointUri == null) {
            Message objectIsNull = CoreMessages.objectIsNull((String)"Endpoint");
            DispatchException ex = null;
            ex = this.endpoint instanceof MessageProcessor ? new DispatchException(objectIsNull, event, (MessageProcessor)this.endpoint, (Throwable)new Exception()) : new DispatchException(objectIsNull, event, null, (Throwable)new Exception());
            throw ex;
        }
        final OpenSpacesQueueMessageReceiver receiver = this.connector.getReceiver(endpointUri);
        TransactionConfig transactionConfig = receiver == null ? this.endpoint.getTransactionConfig() : receiver.getEndpoint().getTransactionConfig();
        TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate((MuleContext)event.getMuleContext(), (TransactionConfig)transactionConfig);
        this.connector.getSessionHandler().storeSessionInfoToMessage(event.getSession(), event.getMessage());
        boolean isTransactional = this.endpoint.getTransactionConfig().isTransacted();
        if (isTransactional && receiver != null) {
            ExecutionCallback<MuleEvent> executionCallback = new ExecutionCallback<MuleEvent>(){

                public MuleEvent process() throws Exception {
                    return (MuleEvent)receiver.onCall(event.getMessage(), true);
                }
            };
            MuleEvent muleEvent = (MuleEvent)executionTemplate.execute((ExecutionCallback)executionCallback);
            return muleEvent != null ? muleEvent.getMessage() : null;
        }
        final boolean returnResponse = this.returnResponse(event, doSend) && !isTransactional;
        final String correlationId = this.createCorrelationIdIfNotExists(event);
        MuleMessage message = event.getMessage();
        this.connector.getSessionHandler().storeSessionInfoToMessage(event.getSession(), message);
        ExecutionCallback<MuleEvent> executionCallback = new ExecutionCallback<MuleEvent>(){

            public MuleEvent process() throws Exception {
                OpenSpacesQueueObject entry = OpenSpacesQueueMessageDispatcher.this.prepareMessageForDispatch(event.getMessage(), endpointUri, correlationId, returnResponse);
                OpenSpacesQueueMessageDispatcher.this.connector.getGigaSpaceObj().write((Object)entry);
                return null;
            }
        };
        executionTemplate.execute((ExecutionCallback)executionCallback);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sent event on endpointUri: " + this.endpoint.getEndpointURI()));
        }
        if (returnResponse) {
            return this.waitForResponse(event, correlationId);
        }
        return null;
    }

    private String createCorrelationIdIfNotExists(MuleEvent event) {
        String correlationId = event.getMessage().getCorrelationId();
        if (correlationId == null || correlationId.trim().length() == 0) {
            correlationId = UUID.randomUUID().toString();
        }
        return correlationId;
    }

    private OpenSpacesQueueObject prepareMessageForDispatch(MuleMessage message, EndpointURI endpointUri, String correlationId, boolean returnResponse) throws IOException {
        OpenSpacesQueueObject entry = this.connector.newQueueEntry(endpointUri.getAddress());
        entry.setCorrelationID(correlationId);
        entry.setPayload(message.getPayload());
        DocumentProperties payloadMetaData = new DocumentProperties();
        for (String propertyName : message.getPropertyNames(PropertyScope.OUTBOUND)) {
            payloadMetaData.put(propertyName, message.getProperty(propertyName, PropertyScope.OUTBOUND));
        }
        if (returnResponse) {
            payloadMetaData.put("OS_QUEUE_RESPONSE_TIMEOUT", (Object)this.endpoint.getResponseTimeout());
        }
        entry.setPayloadMetaData(payloadMetaData);
        return entry;
    }

    private MuleMessage waitForResponse(MuleEvent event, String correlationId) throws Exception {
        String replyTo = this.endpoint.getEndpointURI().getAddress() + DEFAULT_RESPONSE_QUEUE;
        int timeout = this.endpoint.getResponseTimeout();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("waiting for response Event on endpointUri: " + replyTo));
        }
        OpenSpacesQueueObject template = this.connector.newQueueTemplate(replyTo);
        template.setCorrelationID(correlationId);
        try {
            OpenSpacesQueueObject responseEntry = (OpenSpacesQueueObject)this.connector.getGigaSpaceObj().take((Object)template, (long)timeout);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("got response Event on endpointUri: " + replyTo + " response=" + responseEntry));
            }
            if (responseEntry == null) {
                throw new DispatchException(event, (MessageProcessor)this.getEndpoint());
            }
            return this.createMuleMessage(responseEntry);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("got no response Event on endpointUri: " + replyTo));
            }
            throw e;
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

