/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.queue;

import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.query.ISpaceQuery;
import com.j_spaces.core.exception.SpaceUnavailableException;
import java.util.LinkedList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.NullPayload;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.openspaces.core.SpaceClosedException;
import org.openspaces.core.SpaceInterruptedException;
import org.openspaces.esb.mule.queue.OpenSpacesQueueConnector;
import org.openspaces.esb.mule.queue.OpenSpacesQueueObject;

public class OpenSpacesQueueMessageReceiver
extends TransactedPollingMessageReceiver {
    private static final MuleEvent voidEvent = new VoidMuleEvent(){

        public MuleContext getMuleContext() {
            return null;
        }
    };
    private OpenSpacesQueueConnector connector;
    private ISpaceQuery<OpenSpacesQueueObject> template;

    public OpenSpacesQueueMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.init(connector, endpoint);
    }

    public OpenSpacesQueueMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
        super(connector, (FlowConstruct)service, endpoint);
        this.init(connector, endpoint);
    }

    private void init(Connector connector, InboundEndpoint endpoint) {
        this.connector = (OpenSpacesQueueConnector)connector;
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
        this.setFrequency(this.connector.getTimeout() / 10L);
    }

    protected void doConnect() throws Exception {
        OpenSpacesQueueObject internalTemplate = this.connector.newQueueTemplate(this.endpoint.getEndpointURI().getAddress());
        this.template = this.connector.getGigaSpaceObj().prepareTemplate((Object)internalTemplate);
    }

    protected void doDispose() {
    }

    protected void doDisconnect() throws Exception {
    }

    public Object onCall(MuleMessage message, boolean synchronous) throws MuleException {
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message);
        return this.routeMessage((MuleMessage)newMessage);
    }

    protected List getMessages() throws Exception {
        LinkedList<MuleMessage> messages = new LinkedList<MuleMessage>();
        try {
            OpenSpacesQueueObject entry = (OpenSpacesQueueObject)this.connector.getGigaSpaceObj().take(this.template);
            if (entry != null) {
                this.appendMessage(messages, entry);
                OpenSpacesQueueObject[] entries = (OpenSpacesQueueObject[])this.connector.getGigaSpaceObj().takeMultiple(this.template, this.connector.getBatchSize().intValue());
                if (entries != null) {
                    for (OpenSpacesQueueObject entry1 : entries) {
                        this.appendMessage(messages, entry1);
                    }
                }
            }
        }
        catch (SpaceInterruptedException spaceInterruptedException) {
        }
        catch (SpaceClosedException spaceClosedException) {
        }
        catch (SpaceUnavailableException spaceUnavailableException) {
            // empty catch block
        }
        return messages;
    }

    private void appendMessage(List<MuleMessage> messages, OpenSpacesQueueObject entry) throws Exception {
        MuleMessage inboundMessage = this.createMuleMessage(entry);
        messages.add(inboundMessage);
    }

    protected MuleEvent processMessage(Object msg) throws Exception {
        MuleMessage message = (MuleMessage)msg;
        DefaultMuleMessage newMessage = new DefaultMuleMessage((Object)message, this.connector.getMuleContext());
        MuleEvent response = this.routeMessage((MuleMessage)newMessage);
        if (this.endpoint.getExchangePattern().hasResponse() && response != null) {
            Integer lease;
            MuleMessage responseMessage = response.getMessage();
            String correlationId = message.getCorrelationId();
            OpenSpacesQueueObject responseEntry = this.connector.newQueueEntry(this.getEndpointURI().getAddress() + "_response_queue");
            responseEntry.setCorrelationID(correlationId);
            DocumentProperties payloadMetaData = new DocumentProperties();
            for (String propertyName : responseMessage.getPropertyNames(PropertyScope.OUTBOUND)) {
                Object property = responseMessage.getProperty(propertyName, PropertyScope.OUTBOUND);
                payloadMetaData.put(propertyName, property);
            }
            responseEntry.setPayloadMetaData(payloadMetaData);
            Object payload = responseMessage.getPayload();
            if (payload instanceof NullPayload) {
                payload = null;
            }
            responseEntry.setPayload(payload);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.getEndpointURI() + " sending response to client  " + responseEntry));
            }
            if ((lease = (Integer)responseMessage.getOutboundProperty("OS_QUEUE_RESPONSE_TIMEOUT")) != null) {
                this.connector.getGigaSpaceObj().write((Object)responseEntry, (long)lease.intValue());
            } else {
                this.connector.getGigaSpaceObj().write((Object)responseEntry);
            }
        }
        return response != null ? response : voidEvent;
    }

    protected PollingReceiverWorker createWork() {
        return new ReceiverWorker(this);
    }

    protected static class ReceiverWorker
    extends PollingReceiverWorker {
        public ReceiverWorker(OpenSpacesQueueMessageReceiver pollingMessageReceiver) {
            super((AbstractPollingMessageReceiver)pollingMessageReceiver);
        }

        public void run() {
            if (this.getReceiver().isConnected()) {
                super.run();
            }
        }
    }
}

