/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.queue;

import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.openspaces.core.SpaceClosedException;
import org.openspaces.core.SpaceInterruptedException;
import org.openspaces.esb.mule.queue.OpenSpacesQueueConnector;
import org.openspaces.esb.mule.queue.OpenSpacesQueueObject;

public class OpenSpacesQueueMessageRequestor
extends AbstractMessageRequester {
    private final OpenSpacesQueueConnector connector;
    private Object template;

    public OpenSpacesQueueMessageRequestor(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (OpenSpacesQueueConnector)endpoint.getConnector();
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        MuleMessage message = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for a message on " + this.endpoint.getEndpointURI().getAddress()));
        }
        try {
            long startTime = System.currentTimeMillis();
            long currentTime = System.currentTimeMillis();
            long interval = 100L;
            do {
                OpenSpacesQueueObject entry;
                if ((entry = (OpenSpacesQueueObject)this.connector.getGigaSpaceObj().take(this.template)) != null) {
                    return this.createMuleMessage(entry);
                }
                Thread.sleep(interval);
                currentTime = System.currentTimeMillis();
            } while (timeout == -1L || currentTime - startTime < timeout);
        }
        catch (SpaceInterruptedException spaceInterruptedException) {
        }
        catch (SpaceClosedException spaceClosedException) {
            // empty catch block
        }
        if (message != null) {
            if (message instanceof ThreadSafeAccess) {
                ((ThreadSafeAccess)message).resetAccessControl();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received: " + message));
            }
            return message;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No event received after " + timeout + " ms"));
        }
        return null;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        OpenSpacesQueueObject internalTemplate = this.connector.newQueueTemplate(this.endpoint.getEndpointURI().getAddress());
        this.template = this.connector.getGigaSpaceObj().prepareTemplate((Object)internalTemplate);
    }

    protected void doDisconnect() throws Exception {
    }
}

