/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.esb.mule.transaction;

import com.gigaspaces.client.IsolationLevelModifiers;
import com.gigaspaces.client.transaction.DistributedTransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.XAResourceImpl;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.openspaces.core.IsolationLevelHelpers;
import org.openspaces.core.TransactionDataAccessException;
import org.openspaces.core.transaction.TransactionProvider;

public class MuleXATransactionProvider
implements TransactionProvider {
    private final IJSpace space;
    private DistributedTransactionManagerProvider distributedTransactionManagerProvider;
    private final Object distributedTransactionManagerProviderLock = new Object();

    public MuleXATransactionProvider(IJSpace space) {
        this.space = space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction.Created getCurrentTransactionImpl() {
        org.mule.api.transaction.Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (!(tx instanceof XaTransaction)) {
            return null;
        }
        XaTransaction xaTransaction = (XaTransaction)tx;
        if (xaTransaction.hasResource((Object)this.space)) {
            return ((CustomXaResource)xaTransaction.getResource((Object)this.space)).transaction;
        }
        if (this.distributedTransactionManagerProvider == null) {
            Object object = this.distributedTransactionManagerProviderLock;
            synchronized (object) {
                if (this.distributedTransactionManagerProvider == null) {
                    try {
                        this.distributedTransactionManagerProvider = new DistributedTransactionManagerProvider();
                    }
                    catch (TransactionException e) {
                        throw new TransactionDataAccessException("Failed to get local transaction manager for space [" + this.space + "]", (Throwable)e);
                    }
                }
            }
        }
        CustomXaResource xaResourceSpace = new CustomXaResource((XAResource)new XAResourceImpl(this.distributedTransactionManagerProvider.getTransactionManager(), this.space));
        try {
            xaTransaction.bindResource((Object)this.space, (Object)xaResourceSpace);
        }
        catch (Exception e) {
            throw new TransactionDataAccessException("Failed to enlist xa resource [" + xaResourceSpace + "] with space [" + this.space + "]", (Throwable)e);
        }
        Transaction.Created transaction = ((ISpaceProxy)this.space).getContextTransaction();
        ((ISpaceProxy)this.space).replaceContextTransaction(null);
        xaResourceSpace.transaction = transaction;
        return transaction;
    }

    public Transaction getCurrentTransaction() {
        Transaction.Created result = this.getCurrentTransactionImpl();
        return result != null ? result.transaction : null;
    }

    public Transaction.Created getCurrentTransaction(Object transactionalContext, IJSpace space) {
        return this.getCurrentTransactionImpl();
    }

    public IsolationLevelModifiers getCurrentTransactionIsolationLevel() {
        return null;
    }

    public int getCurrentTransactionIsolationLevel(Object transactionalContext) {
        return IsolationLevelHelpers.toSpringIsolationLevel((IsolationLevelModifiers)this.getCurrentTransactionIsolationLevel());
    }

    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws RemoteException {
        Object object = this.distributedTransactionManagerProviderLock;
        synchronized (object) {
            if (this.distributedTransactionManagerProvider != null) {
                this.distributedTransactionManagerProvider.destroy();
            }
        }
    }

    public void close() throws IOException {
        this.destroy();
    }

    private static class CustomXaResource
    implements XAResource {
        public final XAResource actual;
        public Transaction.Created transaction;

        private CustomXaResource(XAResource actual) {
            this.actual = actual;
        }

        @Override
        public void commit(Xid xid, boolean b) throws XAException {
            this.actual.commit(xid, b);
        }

        @Override
        public void end(Xid xid, int i) throws XAException {
            this.actual.end(xid, i);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            this.actual.forget(xid);
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return this.actual.getTransactionTimeout();
        }

        @Override
        public boolean isSameRM(XAResource xaResource) throws XAException {
            return this.actual.isSameRM(xaResource);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            return this.actual.prepare(xid);
        }

        @Override
        public Xid[] recover(int i) throws XAException {
            return this.actual.recover(i);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            this.actual.rollback(xid);
        }

        @Override
        public boolean setTransactionTimeout(int i) throws XAException {
            return this.actual.setTransactionTimeout(i);
        }

        @Override
        public void start(Xid xid, int i) throws XAException {
            this.actual.start(xid, i);
        }
    }
}

