/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpace;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContainerInitializer;
import net.jini.core.discovery.LookupLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.pu.container.CannotCreateContainerException;
import org.openspaces.pu.container.jee.JeeServiceDetails;
import org.openspaces.pu.container.jee.JeeType;
import org.openspaces.pu.container.jee.stats.RequestStatisticsFilter;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.service.ServiceMonitorsProvider;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class RestBean
implements InitializingBean,
ClusterInfoAware,
DisposableBean,
ServiceDetailsProvider,
ServiceMonitorsProvider {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Server server;
    private GigaSpace gigaspace;
    private String spaceName;
    private String groups;
    private String locators;
    private String port;
    int jettyPort;
    private FilterHolder filterHolder;
    private ClusterInfo clusterInfo;
    private WebAppContext webAppContext;
    private boolean jettyStarted = false;
    private Properties properties;

    public void destroy() {
        if (this.jettyStarted) {
            this.logger.info((Object)"Stopping rest service");
            try {
                this.webAppContext.stop();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to stop web context", (Throwable)e);
            }
            try {
                this.server.stop();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to stop rest service", (Throwable)e);
            }
            this.server.destroy();
        }
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaspace = gigaSpace;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public void setLocators(String locators) {
        this.locators = locators;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        String ilocators;
        String igroups;
        String ispaceName;
        int runningNumber = this.clusterInfo.getRunningNumber();
        try {
            this.jettyPort = Integer.valueOf(this.port);
        }
        catch (NumberFormatException e) {
            throw new CannotCreateContainerException("Port should be number");
        }
        this.jettyPort += runningNumber;
        this.server = new Server();
        this.server.setStopAtShutdown(true);
        this.server.setStopTimeout(1000L);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.jettyPort);
        this.server.setConnectors(new Connector[]{connector});
        if (this.gigaspace == null && this.spaceName == null) {
            throw new CannotCreateContainerException("Either giga-space or space-name attribute should be specified.");
        }
        if (this.gigaspace != null && this.spaceName != null) {
            throw new CannotCreateContainerException("Either giga-space or space-name attribute can be specified but not both.");
        }
        if (this.spaceName != null) {
            ispaceName = this.spaceName;
            igroups = this.groups == null ? null : this.groups;
            ilocators = this.locators == null ? null : this.locators;
        } else {
            IJSpace space = this.gigaspace.getSpace();
            ispaceName = space.getName();
            String[] lookupgroups = space.getFinderURL().getLookupGroups();
            igroups = lookupgroups == null || lookupgroups.length == 0 ? null : StringUtils.join((String[])lookupgroups, (String)",", (int)0, (int)lookupgroups.length);
            LookupLocator[] lookuplocators = space.getFinderURL().getLookupLocators();
            if (lookuplocators == null || lookuplocators.length == 0) {
                ilocators = null;
            } else {
                ilocators = "";
                for (int i = 0; i < lookuplocators.length; ++i) {
                    ilocators = ilocators + lookuplocators[i].getHost() + ":" + lookuplocators[i].getPort();
                    if (i == lookuplocators.length - 1) continue;
                    ilocators = ilocators + ",";
                }
            }
        }
        this.logger.info((Object)("Starting REST service on port [" + this.jettyPort + "]"));
        this.webAppContext = new WebAppContext();
        this.filterHolder = new FilterHolder(RequestStatisticsFilter.class);
        this.webAppContext.addFilter(this.filterHolder, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST));
        this.webAppContext.setContextPath("/");
        this.webAppContext.setWar(SystemInfo.singleton().locations().lib() + "/optional/rest/xap-rest.war");
        this.webAppContext.setInitParameter("port", this.port);
        this.webAppContext.setInitParameter("spaceName", ispaceName);
        if (igroups != null && !igroups.equalsIgnoreCase("null")) {
            this.logger.debug((Object)("Applying groups " + igroups));
            this.webAppContext.setInitParameter("lookupGroups", igroups);
        }
        if (ilocators != null && !ilocators.equalsIgnoreCase("null")) {
            this.logger.debug((Object)("Applying locators " + ilocators));
            this.webAppContext.setInitParameter("lookupLocators", ilocators);
        }
        if (this.properties != null && this.properties.getProperty("datetime_format") != null) {
            this.webAppContext.setInitParameter("datetime_format", this.properties.getProperty("datetime_format"));
        }
        this.webAppContext.setCopyWebDir(false);
        this.webAppContext.setParentLoaderPriority(true);
        this.webAppContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/.*taglibs*\\.jar$");
        this.webAppContext.setAttribute("org.eclipse.jetty.containerInitializers", this.jspInitializers());
        this.webAppContext.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        this.webAppContext.addBean((Object)new ServletContainerInitializersStarter(this.webAppContext), true);
        this.webAppContext.addServlet(this.jspServletHolder(), "*.jsp");
        this.server.setHandler((Handler)this.webAppContext);
        try {
            this.server.start();
            this.jettyStarted = true;
            this.logger.info((Object)"REST service is started");
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to start rest service on port [" + this.jettyPort + "]"), (Throwable)e);
            throw new CannotCreateContainerException("Unable to start rest server on port [" + this.jettyPort + "]", (Throwable)e);
        }
    }

    public ServiceDetails[] getServicesDetails() {
        String host = SystemInfo.singleton().network().getHostId();
        JeeServiceDetails details = new JeeServiceDetails(host, this.jettyPort, 0, "/", false, "jetty", JeeType.CUSTOM, 0);
        return new ServiceDetails[]{details};
    }

    public ServiceMonitors[] getServicesMonitors() {
        if (this.jettyStarted && this.filterHolder != null) {
            RequestStatisticsFilter filter = (RequestStatisticsFilter)this.filterHolder.getFilter();
            if (filter == null) {
                this.logger.debug((Object)"Unable to find a running Filter");
                return new ServiceMonitors[0];
            }
            return filter.getServicesMonitors();
        }
        return new ServiceMonitors[0];
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    private ServletHolder jspServletHolder() {
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        holderJsp.setInitParameter("logVerbosityLevel", "DEBUG");
        holderJsp.setInitParameter("fork", "false");
        holderJsp.setInitParameter("xpoweredBy", "false");
        holderJsp.setInitParameter("compilerTargetVM", "1.7");
        holderJsp.setInitParameter("compilerSourceVM", "1.7");
        holderJsp.setInitParameter("keepgenerated", "true");
        return holderJsp;
    }

    private List<ContainerInitializer> jspInitializers() {
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ContainerInitializer initializer = new ContainerInitializer((ServletContainerInitializer)sci, null);
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        initializers.add(initializer);
        return initializers;
    }
}

