/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.DelayedMulticastAnnouncementDecoder;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestEncoder;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.discovery.internal.X500Constraints;
import com.sun.jini.discovery.internal.X500Provider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class X500Client
extends X500Provider
implements MulticastRequestEncoder,
DelayedMulticastAnnouncementDecoder {
    protected X500Client(String formatName, String signatureAlgorithm, int maxSignatureLength, String keyAlgorithm, String keyAlgorithmOID) {
        super(formatName, signatureAlgorithm, maxSignatureLength, keyAlgorithm, keyAlgorithmOID);
    }

    public void encodeMulticastRequest(MulticastRequest request, DatagramBufferFactory bufs, InvocationConstraints constraints) throws IOException {
        if (request == null || bufs == null) {
            throw new NullPointerException();
        }
        try {
            X500Constraints cons = X500Constraints.process(constraints, true);
            X500PrivateCredential[] creds = this.getPrivateCredentials();
            X500PrivateCredential chosen = null;
            int best = -1;
            SecurityException se = null;
            for (int i = 0; i < creds.length; ++i) {
                X500PrivateCredential c = creds[i];
                X500Principal p = c.getCertificate().getSubjectX500Principal();
                int score = cons.checkClientPrincipal(p);
                if (score < 0) {
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, "skipping disallowed principal {0}", new Object[]{p});
                    continue;
                }
                try {
                    this.checkAuthenticationPermission(p, "connect");
                }
                catch (SecurityException e) {
                    se = e;
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "not authorized to use principal {0}", new Object[]{p});
                    continue;
                }
                if (score <= best) continue;
                chosen = c;
                best = score;
            }
            if (chosen == null) {
                UnsupportedConstraintException uce = new UnsupportedConstraintException("unsupported constraints: " + constraints);
                if (se != null) {
                    X500Client.secureThrow(se, uce);
                }
                throw uce;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "using principal {0}", new Object[]{chosen});
            }
            X500Provider.SigningBufferFactory sbf = new X500Provider.SigningBufferFactory(this, bufs, chosen);
            Plaintext.encodeMulticastRequest((MulticastRequest)request, (DatagramBufferFactory)sbf);
            sbf.sign();
        }
        catch (IOException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DiscoveryProtocolException(null, (Throwable)e);
        }
    }

    public MulticastAnnouncement decodeMulticastAnnouncement(ByteBuffer buf, InvocationConstraints constraints, boolean delayConstraintCheck) throws IOException {
        try {
            int len = buf.getInt();
            ByteBuffer data = buf.duplicate();
            data.limit(data.position() + len);
            buf.position(data.limit());
            X500Principal p = new X500Principal(Plaintext.getUtf((ByteBuffer)buf));
            ByteBuffer signed = (ByteBuffer)data.duplicate().position(0);
            MulticastAnnouncement ma = Plaintext.decodeMulticastAnnouncement((ByteBuffer)data);
            ma = new X500MulticastAnnouncement(ma, constraints, p, buf.duplicate(), signed);
            if (!delayConstraintCheck) {
                ma.checkConstraints();
            }
            return ma;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DiscoveryProtocolException(null, (Throwable)e);
        }
    }

    public MulticastAnnouncement decodeMulticastAnnouncement(ByteBuffer buf, InvocationConstraints constraints) throws IOException {
        return this.decodeMulticastAnnouncement(buf, constraints, false);
    }

    private class X500MulticastAnnouncement
    extends MulticastAnnouncement {
        private final InvocationConstraints constraints;
        private final X500Principal p;
        private final ByteBuffer signature;
        private final ByteBuffer signed;

        private X500MulticastAnnouncement(MulticastAnnouncement plainMA, InvocationConstraints constraints, X500Principal p, ByteBuffer signature, ByteBuffer signed) {
            super(plainMA.getSequenceNumber(), plainMA.getHost(), plainMA.getPort(), plainMA.getGroups(), plainMA.getServiceID());
            this.constraints = constraints;
            this.p = p;
            this.signature = signature;
            this.signed = signed;
        }

        public void checkConstraints() throws IOException {
            try {
                X500Constraints cons = X500Constraints.process(this.constraints, false);
                if (cons.checkServerPrincipal(this.p) < 0) {
                    throw new UnsupportedConstraintException("principal not allowed: " + this.p);
                }
                Certificate cert = X500Client.this.getCertificate(this.p);
                if (cert == null) {
                    throw new DiscoveryProtocolException("unknown principal: " + this.p);
                }
                if (X500Provider.logger.isLoggable(Level.FINEST)) {
                    X500Provider.logger.log(Level.FINEST, "mapped principal {0} to {1}", new Object[]{this.p, cert});
                }
                if (!X500Client.this.verify(this.signed.duplicate(), this.signature.duplicate(), cert.getPublicKey())) {
                    throw new DiscoveryProtocolException("signature verification failed: " + this.p);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DiscoveryProtocolException(null, (Throwable)e);
            }
        }
    }
}

