/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.Date;

public class ObjectInputOutputCompressor {
    public static final int _7BIT = 127;
    public static final int _6BIT = 63;
    public static final int _5BIT = 31;
    public static final int _4BIT = 15;
    public static final int BITN7 = 64;
    public static final int BITN8 = 128;
    public static final int FORBYTES = 65535;
    public static final int _8_7_BIT = 192;
    public static final int _8_7_6_BIT = 224;
    public static final int _SECOND_WORD = 240;
    public static final int _ASCII = 127;
    public static final int _FULLY = 64;
    public static final int _MAX_LEN = 32;

    public static boolean readBoolean(ObjectInput ms) throws IOException {
        return ms.read() == 1;
    }

    public static void writeBoolean(ObjectOutput ms, boolean b) throws Exception {
        ms.write(b ? 1 : 0);
    }

    public static byte readByte(ObjectInput in) throws IOException {
        return in.readByte();
    }

    public static void writeByte(ObjectOutput out, byte data) throws IOException {
        out.writeByte(data);
    }

    public static char readChar(ObjectInput in) throws IOException {
        int firstPart = ObjectInputOutputCompressor.readUnsignedByte(in);
        int part = (firstPart & 0xF0) >>> 4;
        if (part >= 0 && part <= 7) {
            return (char)firstPart;
        }
        if (part == 12 || part == 13) {
            int secondPart = ObjectInputOutputCompressor.readUnsignedByte(in);
            if ((secondPart & 0xC0) != 128) {
                throw new IOException();
            }
            return (char)((firstPart & 0x1F) << 6 | secondPart & 0x3F);
        }
        if (part == 14) {
            int secondPart = ObjectInputOutputCompressor.readUnsignedByte(in);
            int thirdPart = ObjectInputOutputCompressor.readUnsignedByte(in);
            if ((secondPart & 0xC0) != 128 || (thirdPart & 0xC0) != 128) {
                throw new IOException();
            }
            return (char)((firstPart & 0xF) << 12 | (secondPart & 0x3F) << 6 | thirdPart & 0x3F);
        }
        throw new IOException();
    }

    public static void writeChar(ObjectOutput out, int data) throws IOException {
        if (data >= 1 && data <= 127) {
            out.write(data);
        } else if (data <= 2047) {
            byte[] buff = new byte[32];
            buff[0] = (byte)(0xC0 | data >>> 6 & 0x1F);
            buff[1] = (byte)(0x80 | data & 0x3F);
            out.write(buff, 0, 2);
        } else {
            byte[] buff = new byte[32];
            buff[0] = (byte)(0xE0 | data >>> 12 & 0xF);
            buff[1] = (byte)(0x80 | data >>> 6 & 0x3F);
            buff[2] = (byte)(0x80 | data & 0x3F);
            out.write(buff, 0, 3);
        }
    }

    public static short readShort(ObjectInput in) throws IOException {
        return (short)ObjectInputOutputCompressor.readInt(in);
    }

    public static void writeShort(ObjectOutput out, short data) throws IOException {
        ObjectInputOutputCompressor.writeInt(out, data);
    }

    public static void writeShort(ObjectOutput out, int data) throws IOException {
        ObjectInputOutputCompressor.writeInt(out, data);
    }

    public static int readInt(ObjectInput in) throws IOException {
        boolean sign;
        int mbyte = ObjectInputOutputCompressor.readUnsignedByte(in);
        int num = mbyte & 0x3F;
        int len = 6;
        boolean bl = sign = (mbyte & 0x40) != 0;
        while ((mbyte & 0x80) != 0) {
            mbyte = ObjectInputOutputCompressor.readUnsignedByte(in);
            num |= (mbyte & 0x7F) << len;
            len += 7;
        }
        if (sign) {
            num ^= 0xFFFFFFFF;
        }
        return num;
    }

    public static void writeInt(ObjectOutput out, int data) throws IOException {
        byte[] buffer = new byte[32];
        int size = 0;
        int mbyte = 0;
        if (data < 0) {
            mbyte = 64;
            data ^= 0xFFFFFFFF;
        }
        mbyte |= (byte)(data & 0x3F);
        data >>>= 6;
        while (data != 0) {
            buffer[size++] = (byte)(mbyte |= 0x80);
            mbyte = data & 0x7F;
            data >>>= 7;
        }
        if (size == 0) {
            out.write(mbyte);
        } else {
            buffer[size++] = (byte)mbyte;
            out.write(buffer, 0, size);
        }
    }

    public static long readLong(ObjectInput in) throws IOException {
        boolean nsig;
        int mbyte = ObjectInputOutputCompressor.readUnsignedByte(in);
        long num = mbyte & 0x3F;
        int len = 6;
        boolean bl = nsig = (mbyte & 0x40) != 0;
        while ((mbyte & 0x80) != 0) {
            mbyte = ObjectInputOutputCompressor.readUnsignedByte(in);
            num |= (long)(mbyte & 0x7F) << len;
            len += 7;
        }
        if (nsig) {
            num ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return num;
    }

    public static void writeLong(ObjectOutput out, long data) throws IOException {
        byte[] buffer = new byte[32];
        int size = 0;
        int mbyte = 0;
        if (data < 0L) {
            mbyte = 64;
            data ^= 0xFFFFFFFFFFFFFFFFL;
        }
        mbyte |= (byte)((int)data & 0x3F);
        data >>>= 6;
        while (data != 0L) {
            buffer[size++] = (byte)(mbyte |= 0x80);
            mbyte = (int)data & 0x7F;
            data >>>= 7;
        }
        if (size == 0) {
            out.write(mbyte);
        } else {
            buffer[size++] = (byte)mbyte;
            out.write(buffer, 0, size);
        }
    }

    public static float readFloat(ObjectInput in) throws IOException {
        int data = ObjectInputOutputCompressor.readInt(in);
        return Float.intBitsToFloat(data);
    }

    public static void writeFloat(ObjectOutput out, float data) throws IOException {
        int idata = Float.floatToIntBits(data);
        ObjectInputOutputCompressor.writeInt(out, idata);
    }

    public static double readDouble(ObjectInput in) throws IOException {
        long data = ObjectInputOutputCompressor.readLong(in);
        return Double.longBitsToDouble(data);
    }

    public static void writeDouble(ObjectOutput out, double data) throws IOException {
        long ldata = Double.doubleToLongBits(data);
        ObjectInputOutputCompressor.writeLong(out, ldata);
    }

    public static String readUTF(ObjectInput in) throws IOException {
        return ObjectInputOutputCompressor.readString(in);
    }

    public static void writeUTF(ObjectOutput out, String data) throws IOException {
        ObjectInputOutputCompressor.writeString(out, data);
    }

    public static String readString(ObjectInput in) throws IOException {
        int count = ObjectInputOutputCompressor.readInt(in);
        if (count == 0) {
            return "";
        }
        int len = ObjectInputOutputCompressor.readInt(in);
        byte[] byff = len > 32 ? new byte[len] : new byte[32];
        ObjectInputOutputCompressor.readBytes(in, byff, 0, len);
        char[] charArr = new char[count];
        int size = 0;
        block5: for (int ofset = 0; ofset < count; ++ofset) {
            byte firstPart = byff[size++];
            switch ((firstPart & 0xF0) >>> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    charArr[ofset] = (char)firstPart;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte secondPart = byff[size++];
                    if ((secondPart & 0xC0) != 128) {
                        throw new RuntimeException();
                    }
                    charArr[ofset] = (char)((firstPart & 0x1F) << 6 | secondPart & 0x3F);
                    continue block5;
                }
                case 14: {
                    byte secondPart = byff[size++];
                    byte thirdPart = byff[size++];
                    if ((secondPart & 0xC0) != 128 || (thirdPart & 0xC0) != 128) {
                        throw new RuntimeException();
                    }
                    charArr[ofset] = (char)((firstPart & 0xF) << 12 | (secondPart & 0x3F) << 6 | thirdPart & 0x3F);
                    continue block5;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return new String(charArr);
    }

    public static void writeString(ObjectOutput out, String data) throws IOException {
        char[] buffer = data.toCharArray();
        int size = buffer.length;
        ObjectInputOutputCompressor.writeInt(out, size);
        if (size > 0) {
            int len = size;
            for (int ofset = 0; ofset < size; ++ofset) {
                char symbol = buffer[ofset];
                if (symbol <= '\u007f') {
                    if (symbol != '\u0000') continue;
                    ++len;
                    continue;
                }
                len += symbol > '\u07ff' ? 2 : 1;
            }
            ObjectInputOutputCompressor.writeInt(out, len);
            byte[] mbyte = len > 32 ? new byte[len] : new byte[32];
            int pos = 0;
            for (int offset = 0; offset < size; ++offset) {
                char symbol = buffer[offset];
                if (symbol >= '\u0001' && symbol <= '\u007f') {
                    mbyte[pos++] = (byte)symbol;
                    continue;
                }
                if (symbol <= '\u07ff') {
                    mbyte[pos++] = (byte)(0xC0 | symbol >>> 6 & 0x1F);
                    mbyte[pos++] = (byte)(0x80 | symbol & 0x3F);
                    continue;
                }
                mbyte[pos++] = (byte)(0xE0 | symbol >>> 12 & 0xF);
                mbyte[pos++] = (byte)(0x80 | symbol >>> 6 & 0x3F);
                mbyte[pos++] = (byte)(0x80 | symbol & 0x3F);
            }
            out.write(mbyte, 0, len);
        }
    }

    public static void readBytes(ObjectInput in, byte[] buff, int ofset, int len) throws IOException {
        if (ofset < 0 || len < 0 || ofset + len > buff.length) {
            throw new IOException();
        }
        while (len > 0) {
            int mbyte = in.read(buff, ofset, len);
            if (mbyte < 0) {
                throw new IOException();
            }
            ofset += mbyte;
            len -= mbyte;
        }
    }

    public static char[] readCharArray(ObjectInput in) throws IOException {
        int sz = ObjectInputOutputCompressor.readInt(in);
        if (sz > 0) {
            byte[] arr = new byte[sz];
            in.read(arr, 0, sz);
            char[] ret = new char[sz];
            int i = 0;
            while (i < sz) {
                ret[i] = (char)arr[i++];
            }
            return ret;
        }
        return null;
    }

    public static void writeCharArray(ObjectOutput out, char[] arr) throws IOException {
        int sz = arr.length;
        ObjectInputOutputCompressor.writeInt(out, sz);
        if (sz > 0) {
            byte[] bytes = new byte[sz];
            int i = 0;
            while (i < sz) {
                bytes[i] = (byte)arr[i++];
            }
            out.write(bytes, 0, sz);
        }
    }

    public static Date readDateTime(ObjectInput in) throws IOException {
        long data = ObjectInputOutputCompressor.readLong(in);
        return new Date(data);
    }

    public static void writeDateTime(ObjectOutput out, Date date) throws IOException {
        long timestamp = date.getTime();
        ObjectInputOutputCompressor.writeLong(out, timestamp);
    }

    public static BigDecimal readDecimal(ObjectInput in) throws IOException {
        return new BigDecimal(ObjectInputOutputCompressor.readString(in));
    }

    public static void writeDecimal(ObjectOutput out, BigDecimal bd) throws IOException {
        ObjectInputOutputCompressor.writeString(out, bd.toEngineeringString());
    }

    public static int readUnsignedByte(ObjectInput in) throws IOException {
        int mbyte = in.read();
        if (mbyte < 0) {
            throw new IOException();
        }
        return mbyte;
    }
}

