/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.instrumentation.stats.Stats;
import com.google.instrumentation.stats.StatsContextFactory;
import com.google.instrumentation.trace.Tracing;
import io.grpc.Attributes;
import io.grpc.ClientInterceptor;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.PickFirstBalancerFactory;
import io.grpc.internal.CensusStatsModule;
import io.grpc.internal.CensusTracingModule;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.ForwardingNameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    @VisibleForTesting
    static final long IDLE_MODE_MAX_TIMEOUT_DAYS = 30L;
    @VisibleForTesting
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    @VisibleForTesting
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    @Nullable
    private Executor executor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    private String userAgent;
    @Nullable
    private String authorityOverride;
    @Nullable
    private NameResolver.Factory nameResolverFactory;
    private LoadBalancer.Factory loadBalancerFactory;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    private long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    private int maxInboundMessageSize = 0x400000;
    private boolean enableStatsTagPropagation;
    private boolean enableTracing;
    @Nullable
    private StatsContextFactory statsFactory;

    @Override
    public T maxInboundMessageSize(int max) {
        Preconditions.checkArgument((max >= 0 ? 1 : 0) != 0, (Object)"negative max");
        this.maxInboundMessageSize = max;
        return this.thisT();
    }

    protected final int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    protected AbstractManagedChannelImplBuilder(String target) {
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.directServerAddress = null;
    }

    @VisibleForTesting
    static String makeTargetStringForDirectAddress(SocketAddress address) {
        try {
            return new URI(DIRECT_ADDRESS_SCHEME, "", "/" + address, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractManagedChannelImplBuilder(SocketAddress directServerAddress, String authority) {
        this.target = AbstractManagedChannelImplBuilder.makeTargetStringForDirectAddress(directServerAddress);
        this.directServerAddress = directServerAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(directServerAddress, authority);
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    @Override
    public final T intercept(ClientInterceptor ... interceptors) {
        return (T)this.intercept((List)Arrays.asList(interceptors));
    }

    @Override
    public final T nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of NameResolverFactory", (Object[])new Object[]{this.directServerAddress});
        this.nameResolverFactory = resolverFactory;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkState((this.directServerAddress == null ? 1 : 0) != 0, (String)"directServerAddress is set (%s), which forbids the use of LoadBalancer.Factory", (Object[])new Object[]{this.directServerAddress});
        this.loadBalancerFactory = loadBalancerFactory;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T userAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
        return this.thisT();
    }

    @Override
    public final T overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this.thisT();
    }

    @Override
    public final T idleTimeout(long value, TimeUnit unit) {
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (String)"idle timeout is %s, but must be positive", (Object[])new Object[]{value});
        this.idleTimeoutMillis = unit.toDays(value) >= 30L ? -1L : Math.max(unit.toMillis(value), IDLE_MODE_MIN_TIMEOUT_MILLIS);
        return this.thisT();
    }

    @VisibleForTesting
    protected final T statsContextFactory(StatsContextFactory statsFactory) {
        this.statsFactory = statsFactory;
        return this.thisT();
    }

    protected boolean recordsStats() {
        return true;
    }

    @VisibleForTesting
    final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    protected String checkAuthority(String authority) {
        return GrpcUtil.checkAuthority(authority);
    }

    @Deprecated
    public void setEnableStatsTagPropagation(boolean enabled) {
        this.enableStatsTagPropagation = enabled;
    }

    @Deprecated
    public void setEnableTracing(boolean enabled) {
        this.enableTracing = enabled;
    }

    @Override
    public ManagedChannel build() {
        ClientTransportFactory transportFactory = this.buildTransportFactory();
        NameResolver.Factory nameResolverFactory = this.nameResolverFactory;
        if (nameResolverFactory == null) {
            nameResolverFactory = NameResolverProvider.asFactory();
        }
        if (this.authorityOverride != null) {
            nameResolverFactory = new OverrideAuthorityNameResolverFactory(nameResolverFactory, this.authorityOverride);
        }
        ArrayList<ClientInterceptor> effectiveInterceptors = new ArrayList<ClientInterceptor>(this.interceptors);
        if (this.recordsStats()) {
            StatsContextFactory statsCtxFactory;
            StatsContextFactory statsContextFactory = statsCtxFactory = this.statsFactory != null ? this.statsFactory : Stats.getStatsContextFactory();
            if (statsCtxFactory != null) {
                CensusStatsModule censusStats = new CensusStatsModule(statsCtxFactory, GrpcUtil.STOPWATCH_SUPPLIER, this.enableStatsTagPropagation);
                effectiveInterceptors.add(0, censusStats.getClientInterceptor());
            }
        }
        if (this.enableTracing) {
            CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getBinaryPropagationHandler());
            effectiveInterceptors.add(0, censusTracing.getClientInterceptor());
        }
        return new ManagedChannelImpl(this.target, new ExponentialBackoffPolicy.Provider(), nameResolverFactory, this.getNameResolverParams(), (LoadBalancer.Factory)MoreObjects.firstNonNull((Object)this.loadBalancerFactory, (Object)PickFirstBalancerFactory.getInstance()), transportFactory, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), AbstractManagedChannelImplBuilder.getExecutorPool(this.executor), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, this.idleTimeoutMillis, this.userAgent, effectiveInterceptors);
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected Attributes getNameResolverParams() {
        return Attributes.EMPTY;
    }

    private static ObjectPool<? extends Executor> getExecutorPool(final @Nullable Executor executor) {
        if (executor != null) {
            return new ObjectPool<Executor>(){

                @Override
                public Executor getObject() {
                    return executor;
                }

                @Override
                public Executor returnObject(Object returned) {
                    return null;
                }
            };
        }
        return SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }

    @VisibleForTesting
    static class OverrideAuthorityNameResolverFactory
    extends NameResolver.Factory {
        private final NameResolver.Factory delegate;
        private final String authorityOverride;

        OverrideAuthorityNameResolverFactory(NameResolver.Factory delegate, String authorityOverride) {
            this.delegate = delegate;
            this.authorityOverride = authorityOverride;
        }

        @Override
        @Nullable
        public NameResolver newNameResolver(URI targetUri, Attributes params) {
            NameResolver resolver = this.delegate.newNameResolver(targetUri, params);
            if (resolver == null) {
                return null;
            }
            return new ForwardingNameResolver(resolver){

                @Override
                public String getServiceAuthority() {
                    return OverrideAuthorityNameResolverFactory.this.authorityOverride;
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return this.delegate.getDefaultScheme();
        }
    }

    private static class DirectAddressNameResolverFactory
    extends NameResolver.Factory {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress address, String authority) {
            this.address = address;
            this.authority = authority;
        }

        @Override
        public NameResolver newNameResolver(URI notUsedUri, Attributes params) {
            return new NameResolver(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(NameResolver.Listener listener) {
                    listener.onAddresses(Collections.singletonList(new EquivalentAddressGroup(DirectAddressNameResolverFactory.this.address)), Attributes.EMPTY);
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return AbstractManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }
}

