/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataIteratorAdapter;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceIdsQuery;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.DataSourceSQLQuery;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.kernel.pool.IResourceFactory;
import com.j_spaces.kernel.pool.IResourcePool;
import com.j_spaces.kernel.pool.IResourceProcedure;
import com.j_spaces.kernel.pool.ResourcePool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cassandra.cql.jdbc.CassandraDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.persistency.ClusterInfoAwareSpaceDataSource;
import org.openspaces.persistency.cassandra.CassandraConsistencyLevel;
import org.openspaces.persistency.cassandra.HectorCassandraClient;
import org.openspaces.persistency.cassandra.datasource.CQLQueryContext;
import org.openspaces.persistency.cassandra.datasource.CassandraTokenRangeAwareDataIterator;
import org.openspaces.persistency.cassandra.datasource.CassandraTokenRangeAwareInitialLoadDataIterator;
import org.openspaces.persistency.cassandra.datasource.SingleEntryDataIterator;
import org.openspaces.persistency.cassandra.error.SpaceCassandraDataSourceException;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.mapping.DefaultSpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;
import org.openspaces.persistency.cassandra.pool.ConnectionResource;
import org.openspaces.persistency.cassandra.pool.ConnectionResourceFactory;
import org.openspaces.persistency.support.SpaceTypeDescriptorContainer;
import org.openspaces.persistency.support.TypeDescriptorUtils;

public class CassandraSpaceDataSource
extends ClusterInfoAwareSpaceDataSource {
    public static final String CQL_VERSION = "2.0.0";
    private static final Log logger = LogFactory.getLog(CassandraSpaceDataSource.class);
    private final SpaceDocumentColumnFamilyMapper mapper;
    private final IResourcePool<ConnectionResource> connectionPool;
    private final HectorCassandraClient hectorClient;
    private final int batchLimit;
    private final CassandraConsistencyLevel readConsistencyLevel;
    private final Object lock = new Object();
    private boolean closed = false;
    private Map<String, SpaceTypeDescriptor> initialLoadEntriesMap = new HashMap<String, SpaceTypeDescriptor>();

    public CassandraSpaceDataSource(PropertyValueSerializer fixedPropertyValueSerializer, PropertyValueSerializer dynamicPropertyValueSerializer, CassandraDataSource cassandraDataSource, HectorCassandraClient hectorClient, int minimumNumberOfConnections, int maximumNumberOfConnections, int batchLimit, String[] initialLoadQueryScanningBasePackages, boolean augmentInitialLoadEntries, ClusterInfo clusterInfo) {
        if (hectorClient == null) {
            throw new IllegalArgumentException("hectorClient must be set and initiated");
        }
        if (cassandraDataSource == null) {
            throw new IllegalArgumentException("dataSource must be set");
        }
        if (!CQL_VERSION.equals(cassandraDataSource.getVersion())) {
            throw new IllegalArgumentException("dataSource version must be set to 2.0.0");
        }
        if (minimumNumberOfConnections <= 0) {
            throw new IllegalArgumentException("minimumNumberOfConnections must be positive number");
        }
        if (maximumNumberOfConnections < minimumNumberOfConnections) {
            throw new IllegalArgumentException("maximumNumberOfConnections must not be smaller thanminimumNumberOfConnections");
        }
        if (batchLimit <= 0) {
            throw new IllegalArgumentException("batchSize must be a positive number");
        }
        this.readConsistencyLevel = hectorClient.getReadConsistencyLevel();
        this.batchLimit = batchLimit;
        this.hectorClient = hectorClient;
        this.hectorClient.createMetadataColumnFamilyColumnFamilyIfNecessary();
        ConnectionResourceFactory resourceFactory = new ConnectionResourceFactory((DataSource)cassandraDataSource);
        this.connectionPool = new ResourcePool((IResourceFactory)resourceFactory, minimumNumberOfConnections, maximumNumberOfConnections);
        this.mapper = new DefaultSpaceDocumentColumnFamilyMapper(fixedPropertyValueSerializer, dynamicPropertyValueSerializer);
        this.initialLoadQueryScanningBasePackages = initialLoadQueryScanningBasePackages;
        this.augmentInitialLoadEntries = augmentInitialLoadEntries;
        this.clusterInfo = clusterInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.connectionPool.forAllResources((IResourceProcedure)new IResourceProcedure<ConnectionResource>(){

                public void invoke(ConnectionResource resource) {
                    resource.close();
                }
            });
            this.closed = true;
        }
    }

    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        boolean performIdQuery;
        String typeName = query.getTypeDescriptor().getTypeName();
        ColumnFamilyMetadata metadata = this.hectorClient.getColumnFamilyMetadata(typeName);
        if (metadata == null && (metadata = this.hectorClient.fetchColumnFamilyMetadata(typeName, this.mapper)) == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Column family for type: " + typeName + " not found."));
            }
            return null;
        }
        CQLQueryContext queryContext = null;
        if (query.supportsTemplateAsDocument()) {
            SpaceDocument templateDocument = query.getTemplateAsDocument();
            Map properties = templateDocument.getProperties();
            queryContext = new CQLQueryContext(properties, null, null);
        } else if (query.supportsAsSQLQuery()) {
            DataSourceSQLQuery sqlQuery = query.getAsSQLQuery();
            Object[] params = sqlQuery.getQueryParameters();
            queryContext = new CQLQueryContext(null, sqlQuery.getQuery(), params);
        } else {
            throw new SpaceCassandraDataSourceException("Unsupported data source query", null);
        }
        Object keyValue = this.getKeyValue(queryContext, metadata);
        boolean bl = performIdQuery = keyValue != null && !this.templateHasPropertyOtherThanKey(queryContext, metadata);
        if (performIdQuery) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Performing single entry query for key: " + keyValue));
            }
            return new SingleEntryDataIterator(this.getByIdImpl(metadata.getTypeName(), keyValue));
        }
        int queryMaxResults = keyValue != null ? 1 : query.getBatchSize();
        int iteratorMaxResults = Integer.MAX_VALUE;
        int actualBatchLimit = queryMaxResults < this.batchLimit ? queryMaxResults : this.batchLimit;
        return new CassandraTokenRangeAwareDataIterator(this.mapper, metadata, (ConnectionResource)this.connectionPool.getResource(), queryContext, iteratorMaxResults, actualBatchLimit, this.readConsistencyLevel);
    }

    private Object getKeyValue(CQLQueryContext queryContext, ColumnFamilyMetadata metadata) {
        if (!queryContext.hasProperties()) {
            return null;
        }
        return queryContext.getProperties().get(metadata.getKeyName());
    }

    private boolean templateHasPropertyOtherThanKey(CQLQueryContext queryContext, ColumnFamilyMetadata metadata) {
        if (!queryContext.hasProperties()) {
            return true;
        }
        for (Map.Entry<String, Object> entry : queryContext.getProperties().entrySet()) {
            if (metadata.getKeyName().equals(entry.getKey()) || entry.getValue() == null) continue;
            return true;
        }
        return false;
    }

    public Object getById(DataSourceIdQuery idQuery) {
        String typeName = idQuery.getTypeDescriptor().getTypeName();
        Object id = idQuery.getId();
        return this.getByIdImpl(typeName, id);
    }

    public DataIterator<Object> getDataIteratorByIds(DataSourceIdsQuery idsQuery) {
        String typeName = idsQuery.getTypeDescriptor().getTypeName();
        Object[] ids = idsQuery.getIds();
        Map<Object, SpaceDocument> documentsByKeys = this.hectorClient.readDocumentsByKeys(this.mapper, typeName, ids);
        return new DataIteratorAdapter(documentsByKeys.values().iterator());
    }

    private Object getByIdImpl(String typeName, Object id) {
        return this.hectorClient.readDocmentByKey(this.mapper, typeName, id);
    }

    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        super.initialMetadataLoad();
        Map<String, ColumnFamilyMetadata> columnFamilies = this.hectorClient.populateColumnFamiliesMetadata(this.mapper);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Loaded the following types from Cassandra for initial metadata load:").append(StringUtils.NEW_LINE);
            for (ColumnFamilyMetadata metadata : columnFamilies.values()) {
                sb.append("\t").append(metadata).append(StringUtils.NEW_LINE);
            }
            logger.debug((Object)sb.toString());
        }
        HashMap<String, SpaceTypeDescriptorContainer> typeDescriptors = new HashMap<String, SpaceTypeDescriptorContainer>();
        for (ColumnFamilyMetadata metadata : columnFamilies.values()) {
            String typeName = metadata.getTypeName();
            SpaceTypeDescriptorContainer spaceTypeDescriptorContainer = metadata.getTypeDescriptorData();
            typeDescriptors.put(typeName, spaceTypeDescriptorContainer);
            if (!this.augmentInitialLoadEntries) continue;
            this.initialLoadEntriesMap.put(typeName, spaceTypeDescriptorContainer.getTypeDescriptor());
        }
        List result = TypeDescriptorUtils.sort(typeDescriptors);
        return new DataIteratorAdapter(result.iterator());
    }

    public DataIterator<Object> initialDataLoad() {
        this.obtainInitialLoadQueries();
        Map<String, ColumnFamilyMetadata> columnFamilies = this.hectorClient.getColumnFamiliesMetadata();
        return new CassandraTokenRangeAwareInitialLoadDataIterator(this.mapper, columnFamilies, (ConnectionResource)this.connectionPool.getResource(), this.initialLoadQueries, this.batchLimit, this.readConsistencyLevel);
    }

    public boolean supportsInheritance() {
        return false;
    }

    protected Map<String, SpaceTypeDescriptor> getInitialLoadEntriesMap() {
        return this.initialLoadEntriesMap;
    }
}

