/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra;

import org.apache.cassandra.cql.jdbc.CassandraDataSource;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.persistency.cassandra.CassandraSpaceDataSource;
import org.openspaces.persistency.cassandra.HectorCassandraClient;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;

public class CassandraSpaceDataSourceConfigurer {
    protected PropertyValueSerializer fixedPropertyValueSerializer;
    protected PropertyValueSerializer dynamicPropertyValueSerializer;
    protected CassandraDataSource cassandraDataSource;
    protected HectorCassandraClient hectorClient;
    protected int minimumNumberOfConnections = 5;
    protected int maximumNumberOfConnections = 30;
    protected int batchLimit = 10000;
    protected String[] initialLoadQueryScanningBasePackages;
    protected boolean augmentInitialLoadEntries = true;
    protected ClusterInfo clusterInfo = null;

    public CassandraSpaceDataSourceConfigurer fixedPropertyValueSerializer(PropertyValueSerializer fixedPropertyValueSerializer) {
        this.fixedPropertyValueSerializer = fixedPropertyValueSerializer;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer dynamicPropertyValueSerializer(PropertyValueSerializer dynamicPropertyValueSerializer) {
        this.dynamicPropertyValueSerializer = dynamicPropertyValueSerializer;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer cassandraDataSource(CassandraDataSource cassandraDataSource) {
        this.cassandraDataSource = cassandraDataSource;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer hectorClient(HectorCassandraClient hectorClient) {
        this.hectorClient = hectorClient;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer minimumNumberOfConnections(int minimumNumberOfConnections) {
        this.minimumNumberOfConnections = minimumNumberOfConnections;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer maximumNumberOfConnections(int maximumNumberOfConnections) {
        this.maximumNumberOfConnections = maximumNumberOfConnections;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer batchLimit(int batchLimit) {
        this.batchLimit = batchLimit;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer initialLoadQueryScanningBasePackages(String[] initialLoadQueryScanningBasePackages) {
        this.initialLoadQueryScanningBasePackages = initialLoadQueryScanningBasePackages;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer clusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
        return this;
    }

    public CassandraSpaceDataSourceConfigurer augmentInitialLoadEntries(boolean augmentInitialLoadEntries) {
        this.augmentInitialLoadEntries = augmentInitialLoadEntries;
        return this;
    }

    public CassandraSpaceDataSource create() {
        return new CassandraSpaceDataSource(this.fixedPropertyValueSerializer, this.dynamicPropertyValueSerializer, this.cassandraDataSource, this.hectorClient, this.minimumNumberOfConnections, this.maximumNumberOfConnections, this.batchLimit, this.initialLoadQueryScanningBasePackages, this.augmentInitialLoadEntries, this.clusterInfo);
    }
}

