/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra;

import org.apache.cassandra.cql.jdbc.CassandraDataSource;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.persistency.cassandra.CassandraSpaceDataSource;
import org.openspaces.persistency.cassandra.CassandraSpaceDataSourceConfigurer;
import org.openspaces.persistency.cassandra.HectorCassandraClient;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class CassandraSpaceDataSourceFactoryBean
implements FactoryBean<CassandraSpaceDataSource>,
InitializingBean,
DisposableBean,
ClusterInfoAware {
    private final CassandraSpaceDataSourceConfigurer configurer = this.getConfigurer();
    private CassandraSpaceDataSource cassandraSpaceDataSource;

    protected CassandraSpaceDataSourceConfigurer getConfigurer() {
        return new CassandraSpaceDataSourceConfigurer();
    }

    public void setFixedPropertyValueSerializer(PropertyValueSerializer fixedPropertyValueSerializer) {
        this.configurer.fixedPropertyValueSerializer(fixedPropertyValueSerializer);
    }

    public void setDynamicPropertyValueSerializer(PropertyValueSerializer dynamicPropertyValueSerializer) {
        this.configurer.dynamicPropertyValueSerializer(dynamicPropertyValueSerializer);
    }

    public void setCassandraDataSource(CassandraDataSource cassandraDataSource) {
        this.configurer.cassandraDataSource(cassandraDataSource);
    }

    public void setHectorClient(HectorCassandraClient hectorClient) {
        this.configurer.hectorClient(hectorClient);
    }

    public void setMinimumNumberOfConnections(int minimumNumberOfConnections) {
        this.configurer.minimumNumberOfConnections(minimumNumberOfConnections);
    }

    public void setMaximumNumberOfConnections(int maximumNumberOfConnections) {
        this.configurer.maximumNumberOfConnections(maximumNumberOfConnections);
    }

    public void setBatchLimit(int batchLimit) {
        this.configurer.batchLimit(batchLimit);
    }

    public void setInitialLoadQueryScanningBasePackages(String ... initialLoadQueryScanningBasePackages) {
        this.configurer.initialLoadQueryScanningBasePackages(initialLoadQueryScanningBasePackages);
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.configurer.clusterInfo(clusterInfo);
    }

    public void augmentInitialLoadEntries(boolean augmentInitialLoadEntries) {
        this.configurer.augmentInitialLoadEntries(augmentInitialLoadEntries);
    }

    public void afterPropertiesSet() throws Exception {
        this.cassandraSpaceDataSource = this.configurer.create();
    }

    public CassandraSpaceDataSource getObject() throws Exception {
        return this.cassandraSpaceDataSource;
    }

    public Class<?> getObjectType() {
        return CassandraSpaceDataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.cassandraSpaceDataSource.close();
    }
}

