/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.sync.AddIndexData;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.IntroduceTypeData;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.gigaspaces.sync.TransactionData;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.persistency.cassandra.HectorCassandraClient;
import org.openspaces.persistency.cassandra.error.SpaceCassandraDataSourceException;
import org.openspaces.persistency.cassandra.error.SpaceCassandraSynchronizationException;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.conversion.ColumnFamilyNameConverter;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.DefaultSpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.mapping.filter.FlattenedPropertiesFilter;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;

public class CassandraSpaceSynchronizationEndpoint
extends SpaceSynchronizationEndpoint {
    private static final Log logger = LogFactory.getLog(CassandraSpaceSynchronizationEndpoint.class);
    private final SpaceDocumentColumnFamilyMapper mapper;
    private final HectorCassandraClient hectorClient;

    public CassandraSpaceSynchronizationEndpoint(PropertyValueSerializer fixedPropertyValueSerializer, PropertyValueSerializer dynamicPropertyValueSerializer, FlattenedPropertiesFilter flattenedPropertiesFilter, ColumnFamilyNameConverter columnFamilyNameConverter, HectorCassandraClient hectorClient) {
        if (hectorClient == null) {
            throw new IllegalArgumentException("hectorClient must be set");
        }
        this.hectorClient = hectorClient;
        this.hectorClient.createMetadataColumnFamilyColumnFamilyIfNecessary();
        this.mapper = new DefaultSpaceDocumentColumnFamilyMapper(fixedPropertyValueSerializer, dynamicPropertyValueSerializer, flattenedPropertiesFilter, columnFamilyNameConverter);
    }

    public void onTransactionSynchronization(TransactionData transactionData) {
        this.doSynchronization(transactionData.getTransactionParticipantDataItems());
    }

    public void onOperationsBatchSynchronization(OperationsBatchData batchData) {
        this.doSynchronization(batchData.getBatchDataItems());
    }

    private void doSynchronization(DataSyncOperation[] dataSyncOperations) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Starting batch operation");
        }
        HashMap<String, LinkedList<ColumnFamilyRow>> cfToRows = new HashMap<String, LinkedList<ColumnFamilyRow>>();
        for (DataSyncOperation dataSyncOperation : dataSyncOperations) {
            LinkedList<ColumnFamilyRow> rows;
            ColumnFamilyRow columnFamilyRow;
            if (!dataSyncOperation.supportsDataAsDocument()) {
                throw new SpaceCassandraSynchronizationException("Data sync operation does not support asDocument", null);
            }
            SpaceDocument spaceDoc = dataSyncOperation.getDataAsDocument();
            String typeName = spaceDoc.getTypeName();
            ColumnFamilyMetadata metadata = this.hectorClient.getColumnFamilyMetadata(typeName);
            if (metadata == null && (metadata = this.hectorClient.fetchColumnFamilyMetadata(typeName, this.mapper)) == null) {
                throw new SpaceCassandraDataSourceException("Could not find column family for type name: " + typeName, null);
            }
            String keyName = metadata.getKeyName();
            Object keyValue = spaceDoc.getProperty(keyName);
            if (keyValue == null) {
                throw new SpaceCassandraSynchronizationException("Data sync operation missing id property value", null);
            }
            switch (dataSyncOperation.getDataSyncOperationType()) {
                case WRITE: {
                    columnFamilyRow = this.mapper.toColumnFamilyRow(metadata, spaceDoc, ColumnFamilyRow.ColumnFamilyRowType.Write, true);
                    break;
                }
                case UPDATE: {
                    columnFamilyRow = this.mapper.toColumnFamilyRow(metadata, spaceDoc, ColumnFamilyRow.ColumnFamilyRowType.Update, true);
                    break;
                }
                case PARTIAL_UPDATE: {
                    columnFamilyRow = this.mapper.toColumnFamilyRow(metadata, spaceDoc, ColumnFamilyRow.ColumnFamilyRowType.PartialUpdate, true);
                    break;
                }
                case REMOVE: {
                    columnFamilyRow = new ColumnFamilyRow(metadata, keyValue, ColumnFamilyRow.ColumnFamilyRowType.Remove);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data sync operation type: " + dataSyncOperation.getDataSyncOperationType());
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Adding row: " + columnFamilyRow + " to current batch"));
            }
            if ((rows = (LinkedList<ColumnFamilyRow>)cfToRows.get(metadata.getColumnFamilyName())) == null) {
                rows = new LinkedList<ColumnFamilyRow>();
                cfToRows.put(metadata.getColumnFamilyName(), rows);
            }
            rows.add(columnFamilyRow);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Performing batch operation");
        }
        for (List rows : cfToRows.values()) {
            this.hectorClient.performBatchOperation(rows);
        }
    }

    public void onIntroduceType(IntroduceTypeData introduceTypeData) {
        ColumnFamilyMetadata columnFamilyMetadata = this.mapper.toColumnFamilyMetadata(introduceTypeData.getTypeDescriptor());
        this.hectorClient.createColumnFamilyIfNecessary(columnFamilyMetadata, true);
    }

    public void onAddIndex(AddIndexData addIndexData) {
        String typeName = addIndexData.getTypeName();
        LinkedList<String> indexes = new LinkedList<String>();
        for (SpaceIndex index : addIndexData.getIndexes()) {
            if (index.getIndexType() == SpaceIndexType.NONE) continue;
            indexes.add(index.getName());
        }
        if (indexes.isEmpty()) {
            return;
        }
        this.hectorClient.addIndexesToColumnFamily(typeName, indexes, this.mapper);
    }
}

