/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra;

import com.gigaspaces.document.SpaceDocument;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import me.prettyprint.cassandra.model.BasicColumnDefinition;
import me.prettyprint.cassandra.model.ConfigurableConsistencyLevel;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.BatchSizeHint;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyRowMapper;
import me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import me.prettyprint.cassandra.service.template.ColumnFamilyUpdater;
import me.prettyprint.cassandra.service.template.MappedColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.HConsistencyLevel;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.persistency.cassandra.CassandraConsistencyLevel;
import org.openspaces.persistency.cassandra.NamedLockProvider;
import org.openspaces.persistency.cassandra.datasource.SpaceDocumentMapper;
import org.openspaces.persistency.cassandra.error.SpaceCassandraSchemaUpdateException;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadataCache;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadataMetadata;
import org.openspaces.persistency.cassandra.meta.TypedColumnMetadata;
import org.openspaces.persistency.cassandra.meta.data.ColumnData;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.types.SerializerProvider;
import org.openspaces.persistency.cassandra.meta.types.ValidatorClassInferer;

public class HectorCassandraClient {
    private static final int SLEEP_BEFORE_RETRY = 11000;
    private static final Log logger = LogFactory.getLog(HectorCassandraClient.class);
    private final NamedLockProvider namedLock = new NamedLockProvider();
    private final ConcurrentMap<String, ColumnFamilyTemplate<Object, String>> templates = new ConcurrentHashMap<String, ColumnFamilyTemplate<Object, String>>();
    private final ConcurrentMap<String, SpaceDocumentMapper> mapperTemplates = new ConcurrentHashMap<String, SpaceDocumentMapper>();
    private final ColumnFamilyMetadataCache metadataCache = new ColumnFamilyMetadataCache();
    private final Integer columnFamilyGcGraceSeconds;
    private final Keyspace keyspace;
    private final Cluster cluster;
    private final Object lock = new Object();
    private boolean closed = false;
    private final CassandraConsistencyLevel readConsistencyLevel;
    private final CassandraConsistencyLevel writeConsistencyLevel;

    public HectorCassandraClient(CassandraHostConfigurator config, String keyspaceName, String clusterName, Integer columnFamilyGcGraceSeconds, CassandraConsistencyLevel readConsistencyLevel, CassandraConsistencyLevel writeConsistencyLevel) {
        CassandraConsistencyLevel actualWriteConsistencyLevel;
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("keyspacename must be set");
        }
        if (columnFamilyGcGraceSeconds != null && columnFamilyGcGraceSeconds < 0) {
            throw new IllegalArgumentException("columnFamilyGcGraceSeconds must be a non negative");
        }
        this.columnFamilyGcGraceSeconds = columnFamilyGcGraceSeconds;
        if (readConsistencyLevel == CassandraConsistencyLevel.ANY) {
            throw new IllegalArgumentException((Object)((Object)readConsistencyLevel) + "consistency is not supported as read  consistency level");
        }
        CassandraConsistencyLevel actualReadConsistencyLevel = readConsistencyLevel;
        if (actualReadConsistencyLevel == null) {
            actualReadConsistencyLevel = CassandraConsistencyLevel.QUORUM;
        }
        if ((actualWriteConsistencyLevel = writeConsistencyLevel) == null) {
            actualWriteConsistencyLevel = CassandraConsistencyLevel.QUORUM;
        }
        this.readConsistencyLevel = actualReadConsistencyLevel;
        this.writeConsistencyLevel = actualWriteConsistencyLevel;
        String hectorClusterName = clusterName;
        if (hectorClusterName == null) {
            hectorClusterName = "cluster";
        }
        this.cluster = HFactory.getOrCreateCluster((String)hectorClusterName, (CassandraHostConfigurator)config);
        this.keyspace = HFactory.createKeyspace((String)keyspaceName, (Cluster)this.cluster, (ConsistencyLevelPolicy)this.createConsistencyLevelPolicy());
        this.validateKeyspaceExists();
    }

    private ConsistencyLevelPolicy createConsistencyLevelPolicy() {
        ConfigurableConsistencyLevel policy = new ConfigurableConsistencyLevel();
        HashMap<String, HConsistencyLevel> mappping = new HashMap<String, HConsistencyLevel>();
        mappping.put("__ColumnFamilyMetadata", HConsistencyLevel.QUORUM);
        policy.setReadCfConsistencyLevels(mappping);
        policy.setWriteCfConsistencyLevels(mappping);
        policy.setDefaultReadConsistencyLevel(HConsistencyLevel.valueOf((String)this.readConsistencyLevel.name()));
        policy.setDefaultWriteConsistencyLevel(HConsistencyLevel.valueOf((String)this.writeConsistencyLevel.name()));
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.cluster != null) {
                HFactory.shutdownCluster((Cluster)this.cluster);
            }
            this.closed = true;
        }
    }

    private void validateKeyspaceExists() {
        KeyspaceDefinition keyspaceDefinition = this.cluster.describeKeyspace(this.keyspace.getKeyspaceName());
        if (keyspaceDefinition == null) {
            throw new IllegalArgumentException("Keyspace: " + this.keyspace.getKeyspaceName() + " does not exits.");
        }
    }

    private ColumnFamilyDefinition getColumnFamilyDefinition(ColumnFamilyMetadata metadata) {
        KeyspaceDefinition keyspaceDefinition = this.cluster.describeKeyspace(this.keyspace.getKeyspaceName());
        List cfDefs = keyspaceDefinition.getCfDefs();
        for (ColumnFamilyDefinition columnFamilyDefinition : cfDefs) {
            if (!columnFamilyDefinition.getName().equals(metadata.getColumnFamilyName())) continue;
            return columnFamilyDefinition;
        }
        return null;
    }

    private boolean isColumnFamilyExists(ColumnFamilyMetadata metadata) {
        return this.getColumnFamilyDefinition(metadata) != null;
    }

    public void createMetadataColumnFamilyColumnFamilyIfNecessary() {
        this.createColumnFamilyIfNecessary(ColumnFamilyMetadataMetadata.INSTANCE, true);
    }

    public void performBatchOperation(List<ColumnFamilyRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        Serializer<?> keySerializer = rows.iterator().next().getColumnFamilyMetadata().getKeySerializer();
        Mutator<Object> mutator = this.createMutator(rows.size(), keySerializer);
        block5: for (ColumnFamilyRow row : rows) {
            switch (row.getRowType()) {
                case Update: {
                    mutator.addDeletion(row.getKeyValue(), row.getColumnFamilyMetadata().getColumnFamilyName());
                }
                case PartialUpdate: 
                case Write: {
                    for (ColumnData columnData : row.getColumns().values()) {
                        if (columnData.getValue() == null) continue;
                        mutator.addInsertion(row.getKeyValue(), row.getColumnFamilyMetadata().getColumnFamilyName(), HFactory.createColumn((Object)columnData.getColumnMetadata().getFullName(), (Object)columnData.getValue(), (Serializer)StringSerializer.get(), columnData.getColumnMetadata().getSerializer()));
                    }
                    continue block5;
                }
                case Remove: {
                    mutator.addDeletion(row.getKeyValue(), row.getColumnFamilyMetadata().getColumnFamilyName());
                    break;
                }
                default: {
                    throw new IllegalStateException("should not have gotten here, got: " + (Object)((Object)row.getRowType()));
                }
            }
        }
        mutator.execute();
    }

    private Mutator<Object> createMutator(int numberOfRowsHint, Serializer<?> keySerializer) {
        return HFactory.createMutator((Keyspace)this.keyspace, keySerializer, (BatchSizeHint)new BatchSizeHint(numberOfRowsHint, 15));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createColumnFamilyIfNecessary(ColumnFamilyMetadata metadata, boolean shouldPersist) {
        ReentrantLock lockForType = this.namedLock.forName(metadata.getTypeName());
        lockForType.lock();
        try {
            String validationClass;
            boolean columnFamilyExists = this.isColumnFamilyExists(metadata);
            if (columnFamilyExists) {
                if (metadata != ColumnFamilyMetadataMetadata.INSTANCE) {
                    this.metadataCache.addColumnFamilyMetadata(metadata.getTypeName(), metadata);
                    if (shouldPersist) {
                        this.persistColumnFamilyMetadata(metadata);
                    }
                }
                return;
            }
            ThriftCfDef cfDef = (ThriftCfDef)HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)metadata.getColumnFamilyName());
            cfDef.setColumnMetadata(new ArrayList());
            cfDef.setDefaultValidationClass(ValidatorClassInferer.getBytesTypeValidationClass());
            cfDef.setComparatorType(StringSerializer.get().getComparatorType());
            cfDef.setKeyAlias(StringSerializer.get().toByteBuffer(metadata.getKeyName()));
            cfDef.setKeyValidationClass(ValidatorClassInferer.infer(metadata.getKeyType()));
            cfDef.setComment(metadata.getTypeName());
            if (this.columnFamilyGcGraceSeconds != null) {
                cfDef.setGcGraceSeconds(this.columnFamilyGcGraceSeconds.intValue());
            }
            for (TypedColumnMetadata columnMetadata : metadata.getColumns().values()) {
                validationClass = ValidatorClassInferer.infer(columnMetadata.getType());
                this.addColumnDefinitionToColumnFamilyDefinition(metadata, cfDef, columnMetadata.getFullName(), validationClass);
            }
            for (String index : metadata.getIndexes()) {
                if (metadata.getColumns().containsKey(index)) continue;
                validationClass = ValidatorClassInferer.getBytesTypeValidationClass();
                this.addColumnDefinitionToColumnFamilyDefinition(metadata, cfDef, index, validationClass);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Creating column family: " + metadata));
            }
            try {
                block18: {
                    try {
                        this.cluster.addColumnFamily((ColumnFamilyDefinition)cfDef, true);
                    }
                    catch (Exception e) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"Column family creation failed, waiting 11 seconds and then testing to see whether the column family was already created.", (Throwable)e);
                        }
                        Thread.sleep(11000L);
                        if (this.isColumnFamilyExists(metadata)) break block18;
                        throw e;
                    }
                }
                if (metadata != ColumnFamilyMetadataMetadata.INSTANCE) {
                    this.metadataCache.addColumnFamilyMetadata(metadata.getTypeName(), metadata);
                    if (shouldPersist) {
                        this.persistColumnFamilyMetadata(metadata);
                    }
                }
            }
            catch (Exception e) {
                throw new SpaceCassandraSchemaUpdateException("Failed adding column family definition to cassandra", e, true);
            }
        }
        finally {
            lockForType.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexesToColumnFamily(String typeName, List<String> columnNames, SpaceDocumentColumnFamilyMapper mapper) {
        ColumnFamilyMetadata metadata = this.metadataCache.getColumnFamilyMetadata(typeName);
        if (metadata == null && (metadata = this.fetchColumnFamilyMetadata(typeName, mapper)) == null) {
            throw new SpaceCassandraSchemaUpdateException("Failed finding column family metadata for " + typeName, null, false);
        }
        ReentrantLock lockForType = this.namedLock.forName(metadata.getTypeName());
        lockForType.lock();
        try {
            metadata.getIndexes().addAll(columnNames);
            ColumnFamilyDefinition columnFamilyDefinition = this.getColumnFamilyDefinition(metadata);
            if (columnFamilyDefinition == null) {
                throw new SpaceCassandraSchemaUpdateException("column family definition: " + metadata.getColumnFamilyName() + " for type: " + typeName + " not found", null, false);
            }
            ThriftCfDef thriftCfDef = new ThriftCfDef(columnFamilyDefinition);
            for (String columnName : columnNames) {
                ByteBuffer serializedColumnName = StringSerializer.get().toByteBuffer(columnName);
                ColumnDefinition originalColumnDefinition = this.getColumnDefinition(serializedColumnName, thriftCfDef);
                if (originalColumnDefinition == null) {
                    String validationClass = ValidatorClassInferer.getBytesTypeValidationClass();
                    this.addColumnDefinitionToColumnFamilyDefinition(metadata, thriftCfDef, columnName, validationClass);
                    continue;
                }
                if (originalColumnDefinition.getIndexName() != null) continue;
                List currentColumns = thriftCfDef.getColumnMetadata();
                thriftCfDef.setColumnMetadata(new ArrayList());
                BasicColumnDefinition replacedColumnDefinition = new BasicColumnDefinition();
                replacedColumnDefinition.setName(originalColumnDefinition.getName());
                replacedColumnDefinition.setValidationClass(originalColumnDefinition.getValidationClass());
                replacedColumnDefinition.setIndexName(HectorCassandraClient.generateIndexName(typeName, columnName));
                replacedColumnDefinition.setIndexType(ColumnIndexType.KEYS);
                for (ColumnDefinition columnDef : currentColumns) {
                    if (columnDef != originalColumnDefinition) {
                        thriftCfDef.addColumnDefinition(columnDef);
                        continue;
                    }
                    thriftCfDef.addColumnDefinition((ColumnDefinition)replacedColumnDefinition);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Adding indexes to columns: " + columnNames + " of type: " + metadata.getTypeName() + ", column family: " + metadata.getColumnFamilyName()));
            }
            try {
                this.cluster.updateColumnFamily((ColumnFamilyDefinition)thriftCfDef, true);
            }
            catch (Exception e) {
                throw new SpaceCassandraSchemaUpdateException("Failed adding column family definition to cassandra", null, true);
            }
        }
        finally {
            lockForType.unlock();
        }
    }

    private ColumnDefinition getColumnDefinition(ByteBuffer serializedColumnName, ThriftCfDef thriftCfDef) {
        for (ColumnDefinition columnDef : thriftCfDef.getColumnMetadata()) {
            if (!serializedColumnName.equals(columnDef.getName())) continue;
            return columnDef;
        }
        return null;
    }

    private void addColumnDefinitionToColumnFamilyDefinition(ColumnFamilyMetadata metadata, ThriftCfDef columnFamilyDefinition, String columnFullName, String validationClass) {
        BasicColumnDefinition columnDefinition = new BasicColumnDefinition();
        ByteBuffer serializedName = StringSerializer.get().toByteBuffer(columnFullName);
        columnDefinition.setName(serializedName);
        columnDefinition.setValidationClass(validationClass);
        if (metadata.getIndexes().contains(columnFullName)) {
            columnDefinition.setIndexName(HectorCassandraClient.generateIndexName(metadata.getTypeName(), columnFullName));
            columnDefinition.setIndexType(ColumnIndexType.KEYS);
        }
        columnFamilyDefinition.addColumnDefinition((ColumnDefinition)columnDefinition);
    }

    private static String generateIndexName(String typeName, String columnName) {
        return (typeName + "_" + columnName).replace(".", "_");
    }

    private void persistColumnFamilyMetadata(ColumnFamilyMetadata metadata) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding metadata for type " + metadata.getTypeName() + " to internal metadata column family"));
        }
        try {
            ColumnFamilyTemplate<Object, String> template = this.getTemplate(ColumnFamilyMetadataMetadata.INSTANCE);
            ColumnFamilyUpdater updater = template.createUpdater((Object)metadata.getTypeName());
            updater.setByteBuffer((Object)"metadata", SerializerProvider.getObjectSerializer().toByteBuffer((Object)metadata));
            template.update(updater);
        }
        catch (Exception e) {
            throw new SpaceCassandraSchemaUpdateException("Failed persisting column family metadata for " + metadata.getTypeName(), e, true);
        }
    }

    public ColumnFamilyMetadata fetchColumnFamilyMetadata(String typeName, SpaceDocumentColumnFamilyMapper mapper) {
        ColumnFamilyTemplate<Object, String> template = this.getTemplate(ColumnFamilyMetadataMetadata.INSTANCE);
        if (!template.isColumnsExist((Object)typeName)) {
            return null;
        }
        ColumnFamilyResult result = template.queryColumns((Object)typeName);
        HColumn column = result.getColumn((Object)"metadata");
        ColumnFamilyMetadata newMetadata = (ColumnFamilyMetadata)SerializerProvider.getObjectSerializer().fromByteBuffer(column.getValueBytes());
        this.initMetadataAndAddToCache(mapper, newMetadata);
        return newMetadata;
    }

    public Map<String, ColumnFamilyMetadata> populateColumnFamiliesMetadata(SpaceDocumentColumnFamilyMapper mapper) {
        RangeSlicesQuery rangeQuery = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), SerializerProvider.getObjectSerializer()).setColumnFamily("__ColumnFamilyMetadata").setColumnNames((Object[])new String[]{"metadata"}).setKeys((Object)"", (Object)"");
        OrderedRows result = (OrderedRows)rangeQuery.execute().get();
        for (Row row : result) {
            HColumn column = row.getColumnSlice().getColumnByName((Object)"metadata");
            ColumnFamilyMetadata metadata = (ColumnFamilyMetadata)column.getValue();
            this.initMetadataAndAddToCache(mapper, metadata);
        }
        return this.metadataCache.getColumnFamiliesMetadata();
    }

    private void initMetadataAndAddToCache(SpaceDocumentColumnFamilyMapper mapper, ColumnFamilyMetadata metadata) {
        Serializer<Object> fixedPropertyValueSerializer = mapper.getTypeNodeIntrospector().getFixedPropertyValueSerializer();
        if (fixedPropertyValueSerializer != null) {
            metadata.setFixedPropertySerializerForTypedColumn(fixedPropertyValueSerializer);
        }
        this.metadataCache.addColumnFamilyMetadata(metadata.getTypeName(), metadata);
    }

    public SpaceDocument readDocmentByKey(SpaceDocumentColumnFamilyMapper mapper, String typeName, Object keyValue) {
        ColumnFamilyMetadata metadata = this.metadataCache.getColumnFamilyMetadata(typeName);
        if (metadata == null && (metadata = this.fetchColumnFamilyMetadata(typeName, mapper)) == null) {
            return null;
        }
        ColumnFamilyTemplate<Object, String> template = this.getTemplate(metadata);
        if (!template.isColumnsExist(keyValue)) {
            return null;
        }
        SpaceDocumentMapper hectorMapper = this.getMapperTemplate(metadata, mapper);
        try {
            return (SpaceDocument)template.queryColumns(keyValue, (ColumnFamilyRowMapper)hectorMapper);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<Object, SpaceDocument> readDocumentsByKeys(SpaceDocumentColumnFamilyMapper mapper, String typeName, Object[] keyValues) {
        Map<Object, SpaceDocument> result = Collections.emptyMap();
        ColumnFamilyMetadata metadata = this.metadataCache.getColumnFamilyMetadata(typeName);
        if (metadata == null && (metadata = this.fetchColumnFamilyMetadata(typeName, mapper)) == null) {
            return result;
        }
        ColumnFamilyTemplate<Object, String> template = this.getTemplate(metadata);
        SpaceDocumentMapper hectorMapper = this.getMapperTemplate(metadata, mapper);
        MappedColumnFamilyResult queryResult = template.queryColumns(Arrays.asList(keyValues), (ColumnFamilyRowMapper)hectorMapper);
        for (int i = 0; i < keyValues.length; ++i) {
            if (queryResult.hasResults()) {
                if (result.isEmpty()) {
                    result = new HashMap<Object, SpaceDocument>();
                }
                result.put(queryResult.getKey(), (SpaceDocument)queryResult.getRow());
            }
            if (i >= keyValues.length - 1) continue;
            queryResult.next();
        }
        return result;
    }

    private ColumnFamilyTemplate<Object, String> getTemplate(ColumnFamilyMetadata metadata) {
        ColumnFamilyTemplate template = (ColumnFamilyTemplate)this.templates.get(metadata.getTypeName());
        if (template == null) {
            template = new ThriftColumnFamilyTemplate(this.keyspace, metadata.getColumnFamilyName(), metadata.getKeySerializer(), (Serializer)StringSerializer.get());
            this.templates.put(metadata.getTypeName(), (ColumnFamilyTemplate<Object, String>)template);
        }
        return template;
    }

    private SpaceDocumentMapper getMapperTemplate(ColumnFamilyMetadata metadata, SpaceDocumentColumnFamilyMapper mapper) {
        SpaceDocumentMapper mapperTemplate = (SpaceDocumentMapper)this.mapperTemplates.get(metadata.getTypeName());
        if (mapperTemplate == null) {
            mapperTemplate = new SpaceDocumentMapper(metadata, mapper);
            this.mapperTemplates.put(metadata.getTypeName(), mapperTemplate);
        }
        return mapperTemplate;
    }

    public ColumnFamilyMetadata getColumnFamilyMetadata(String typeName) {
        return this.metadataCache.getColumnFamilyMetadata(typeName);
    }

    public Map<String, ColumnFamilyMetadata> getColumnFamiliesMetadata() {
        return this.metadataCache.getColumnFamiliesMetadata();
    }

    public CassandraConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public CassandraConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }
}

