/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra;

import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import org.openspaces.persistency.cassandra.CassandraConsistencyLevel;
import org.openspaces.persistency.cassandra.HectorCassandraClient;
import org.springframework.util.StringUtils;

public class HectorCassandraClientConfigurer {
    protected String hosts;
    protected Integer port;
    protected String clusterName;
    protected String keyspaceName;
    protected Integer columnFamilyGcGraceSeconds;
    protected CassandraConsistencyLevel readConsistencyLevel;
    protected CassandraConsistencyLevel writeConsistencyLevel;

    public HectorCassandraClientConfigurer hosts(String hosts) {
        this.hosts = hosts;
        return this;
    }

    public HectorCassandraClientConfigurer port(Integer port) {
        this.port = port;
        return this;
    }

    public HectorCassandraClientConfigurer keyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
        return this;
    }

    public HectorCassandraClientConfigurer clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public HectorCassandraClientConfigurer columnFamilyGcGraceSeconds(Integer columnFamilyGcGraceSeconds) {
        this.columnFamilyGcGraceSeconds = columnFamilyGcGraceSeconds;
        return this;
    }

    public HectorCassandraClientConfigurer readConsistencyLevel(CassandraConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
        return this;
    }

    public HectorCassandraClientConfigurer writeConsistencyLevel(CassandraConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
        return this;
    }

    public HectorCassandraClient create() {
        if (this.hosts == null) {
            throw new IllegalArgumentException("hosts must be set");
        }
        if (!StringUtils.hasLength((String)this.hosts.replace(",", ""))) {
            throw new IllegalArgumentException("hosts cannot be null or empty");
        }
        if (this.port != null && this.port <= 0) {
            throw new IllegalArgumentException("port must be positive number");
        }
        if (this.port == null) {
            this.port = 9160;
        }
        CassandraHostConfigurator config = new CassandraHostConfigurator();
        config.setHosts(this.hosts);
        config.setPort(this.port.intValue());
        return new HectorCassandraClient(config, this.keyspaceName, this.clusterName, this.columnFamilyGcGraceSeconds, this.readConsistencyLevel, this.writeConsistencyLevel);
    }
}

