/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.archive;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptorBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.archive.ArchiveOperationHandler;
import org.openspaces.core.GigaSpace;
import org.openspaces.persistency.cassandra.CassandraConsistencyLevel;
import org.openspaces.persistency.cassandra.HectorCassandraClient;
import org.openspaces.persistency.cassandra.HectorCassandraClientConfigurer;
import org.openspaces.persistency.cassandra.archive.SpaceCassandraArchiveOperationHandlerException;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.conversion.ColumnFamilyNameConverter;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.DefaultSpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.mapping.filter.FlattenedPropertiesFilter;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;
import org.springframework.beans.factory.annotation.Required;

public class CassandraArchiveOperationHandler
implements ArchiveOperationHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private GigaSpace gigaSpace;
    private PropertyValueSerializer propertyValueSerializer;
    private FlattenedPropertiesFilter flattenedPropertiesFilter;
    private ColumnFamilyNameConverter columnFamilyNameConverter;
    private String hosts;
    private Integer port;
    private String keyspace;
    private HectorCassandraClient hectorClient;
    private DefaultSpaceDocumentColumnFamilyMapper mapper;
    private CassandraConsistencyLevel writeConsistency;

    @Required
    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    @Required
    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @Required
    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setWriteConsistency(CassandraConsistencyLevel writeConsistency) {
        this.writeConsistency = writeConsistency;
    }

    public void setPropertyValueSerializer(PropertyValueSerializer propertyValueSerializer) {
        this.propertyValueSerializer = propertyValueSerializer;
    }

    public void setFlattenedPropertiesFilter(FlattenedPropertiesFilter flattenedPropertiesFilter) {
        this.flattenedPropertiesFilter = flattenedPropertiesFilter;
    }

    public void setColumnFamilyNameConverter(ColumnFamilyNameConverter columnFamilyNameConverter) {
        this.columnFamilyNameConverter = columnFamilyNameConverter;
    }

    public GigaSpace getGigaSpace() {
        return this.gigaSpace;
    }

    public PropertyValueSerializer getPropertyValueSerializer() {
        return this.propertyValueSerializer;
    }

    public FlattenedPropertiesFilter getFlattenedPropertiesFilter() {
        return this.flattenedPropertiesFilter;
    }

    public ColumnFamilyNameConverter getColumnFamilyNameConverter() {
        return this.columnFamilyNameConverter;
    }

    public String getHosts() {
        return this.hosts;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public CassandraConsistencyLevel getWriteConsistency() {
        return this.writeConsistency;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (this.gigaSpace == null) {
            throw new IllegalArgumentException("gigaSpace cannot be null");
        }
        this.createMapper();
        this.createHectorClient();
    }

    private void createHectorClient() {
        String clusterName = CassandraArchiveOperationHandler.createHectorDefaultClusterName(this.hosts, this.port);
        this.hectorClient = new HectorCassandraClientConfigurer().hosts(this.hosts).port(this.port).keyspaceName(this.keyspace).clusterName(clusterName).writeConsistencyLevel(this.writeConsistency).create();
    }

    private void createMapper() {
        PropertyValueSerializer dynamicPropertyValueSerializer = null;
        this.mapper = new DefaultSpaceDocumentColumnFamilyMapper(this.propertyValueSerializer, dynamicPropertyValueSerializer, this.flattenedPropertiesFilter, this.columnFamilyNameConverter);
    }

    @PreDestroy
    public void destroy() {
        if (this.hectorClient != null) {
            this.hectorClient.close();
        }
    }

    public void archive(Object ... objects) {
        HashMap<String, LinkedList<ColumnFamilyRow>> cfToRows = new HashMap<String, LinkedList<ColumnFamilyRow>>();
        for (Object object : objects) {
            String keyName;
            Object keyValue;
            if (!(object instanceof SpaceDocument)) {
                throw new SpaceCassandraArchiveOperationHandlerException(object.getClass() + " is not supported since it is not a " + SpaceDocument.class.getName());
            }
            SpaceDocument spaceDoc = (SpaceDocument)object;
            String typeName = spaceDoc.getTypeName();
            ColumnFamilyMetadata metadata = this.hectorClient.getColumnFamilyMetadata(typeName);
            if (metadata == null) {
                metadata = this.createColumnFamilyMetadata(typeName);
                this.hectorClient.createColumnFamilyIfNecessary(metadata, false);
            }
            if ((keyValue = spaceDoc.getProperty(keyName = metadata.getKeyName())) == null) {
                throw new SpaceCassandraArchiveOperationHandlerException(object.getClass() + " entry is illegal since SpaceId property is undefined");
            }
            boolean useDynamicPropertySerializerForDynamicColumns = false;
            ColumnFamilyRow columnFamilyRow = this.mapper.toColumnFamilyRow(metadata, spaceDoc, ColumnFamilyRow.ColumnFamilyRowType.Write, useDynamicPropertySerializerForDynamicColumns);
            LinkedList<ColumnFamilyRow> rows = (LinkedList<ColumnFamilyRow>)cfToRows.get(metadata.getColumnFamilyName());
            if (rows == null) {
                rows = new LinkedList<ColumnFamilyRow>();
                cfToRows.put(metadata.getColumnFamilyName(), rows);
            }
            rows.add(columnFamilyRow);
        }
        for (List rows : cfToRows.values()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Writing to cassandra " + rows.size() + " objects"));
            }
            this.hectorClient.performBatchOperation(rows);
        }
    }

    private ColumnFamilyMetadata createColumnFamilyMetadata(String typeName) {
        SpaceTypeDescriptor typeDesc = this.gigaSpace.getTypeManager().getTypeDescriptor(typeName);
        if (typeDesc == null) {
            throw new SpaceCassandraArchiveOperationHandlerException("Cannot find type descriptor of " + typeName);
        }
        String keyName = typeDesc.getIdPropertyName();
        Class keyType = typeDesc.getFixedProperty(keyName).getType();
        SpaceTypeDescriptor dynamicTypeDesc = new SpaceTypeDescriptorBuilder(typeName).addFixedProperty(keyName, keyType).idProperty(keyName).addFixedProperty("stub", Object.class).create();
        return this.mapper.toColumnFamilyMetadata(dynamicTypeDesc);
    }

    public boolean supportsBatchArchiving() {
        return true;
    }

    private static String createHectorDefaultClusterName(String hosts, Integer port) {
        return hosts.replace(",", "_").replace(" ", "") + (port == null ? "" : port);
    }
}

