/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.archive;

import org.openspaces.persistency.cassandra.archive.CassandraArchiveOperationHandler;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CassandraArchiveOperationHandlerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String GIGA_SPACE = "giga-space";
    private static final String CASSANDRA_KEYSPACE = "keyspace";
    private static final String CASSANDRA_HOSTS = "hosts";
    private static final String CASSANDRA_PORT = "port";
    private static final String CASSANDRA_CONSISTENCY = "write-consistency";

    protected Class<CassandraArchiveOperationHandler> getBeanClass(Element element) {
        return CassandraArchiveOperationHandler.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String consistency;
        String port;
        String hosts;
        String keyspace;
        super.doParse(element, parserContext, builder);
        String gigaSpace = element.getAttribute(GIGA_SPACE);
        if (StringUtils.hasLength((String)gigaSpace)) {
            builder.addPropertyReference("gigaSpace", gigaSpace);
        }
        if (StringUtils.hasLength((String)(keyspace = element.getAttribute(CASSANDRA_KEYSPACE)))) {
            builder.addPropertyValue(CASSANDRA_KEYSPACE, (Object)keyspace);
        }
        if (StringUtils.hasLength((String)(hosts = element.getAttribute(CASSANDRA_HOSTS)))) {
            builder.addPropertyValue(CASSANDRA_HOSTS, (Object)hosts);
        }
        if (StringUtils.hasLength((String)(port = element.getAttribute(CASSANDRA_PORT)))) {
            builder.addPropertyValue(CASSANDRA_PORT, (Object)port);
        }
        if (StringUtils.hasLength((String)(consistency = element.getAttribute(CASSANDRA_CONSISTENCY)))) {
            builder.addPropertyValue("writeConsistency", (Object)consistency);
        }
    }
}

