/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.document.SpaceDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.persistency.cassandra.CassandraConsistencyLevel;
import org.openspaces.persistency.cassandra.CassandraSpaceDataSource;
import org.openspaces.persistency.cassandra.datasource.CQLQueryContext;
import org.openspaces.persistency.cassandra.datasource.CassandraTokenRangeJDBCDataIterator;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.pool.ConnectionResource;

public class CassandraTokenRangeAwareDataIterator
implements DataIterator<Object> {
    private static final Log logger = LogFactory.getLog(CassandraSpaceDataSource.class);
    private final ConnectionResource connectionResource;
    private final SpaceDocumentColumnFamilyMapper mapper;
    private final ColumnFamilyMetadata columnFamilyMetadata;
    private final int maxResults;
    private final int batchLimit;
    private final CQLQueryContext queryContext;
    private final CassandraConsistencyLevel readConsistencyLevel;
    private boolean closed = false;
    private CassandraTokenRangeJDBCDataIterator currentIterator;
    private Object currentLastToken = null;
    private int currentResultCount = 0;

    public CassandraTokenRangeAwareDataIterator(SpaceDocumentColumnFamilyMapper mapper, ColumnFamilyMetadata columnFamilyMetadata, ConnectionResource connectionResource, CQLQueryContext queryContext, int maxResults, int batchLimit, CassandraConsistencyLevel readConsistencyLevel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating data iterator for query: " + queryContext + " for type: " + columnFamilyMetadata.getTypeName() + ", batchLimit=" + batchLimit));
        }
        this.mapper = mapper;
        this.columnFamilyMetadata = columnFamilyMetadata;
        this.connectionResource = connectionResource;
        this.queryContext = queryContext;
        this.maxResults = maxResults;
        this.batchLimit = batchLimit;
        this.readConsistencyLevel = readConsistencyLevel;
        this.currentIterator = this.nextDataIterator();
    }

    public boolean hasNext() {
        while (this.currentIterator != null && !this.currentIterator.hasNext()) {
            this.currentIterator.closeSelfResources();
            this.currentIterator = this.nextDataIterator();
        }
        return this.currentIterator != null;
    }

    public SpaceDocument next() {
        ++this.currentResultCount;
        return this.currentIterator.next();
    }

    private CassandraTokenRangeJDBCDataIterator nextDataIterator() {
        if (this.calculateRemainingResults() <= 0) {
            return null;
        }
        if (this.currentIterator == null) {
            CassandraTokenRangeJDBCDataIterator result = this.createIterator();
            if (result.getLastToken() == null) {
                this.currentResultCount = this.maxResults;
            }
            return result;
        }
        this.currentLastToken = this.currentIterator.getLastToken();
        if (this.currentLastToken == null || this.currentIterator.getCurrentTotalCount() < this.currentIterator.getLimit()) {
            return null;
        }
        return this.createIterator();
    }

    private CassandraTokenRangeJDBCDataIterator createIterator() {
        return new CassandraTokenRangeJDBCDataIterator(this.mapper, this.columnFamilyMetadata, this.connectionResource, this.queryContext, this.currentLastToken, this.calculateRemainingResults(), this.readConsistencyLevel);
    }

    private int calculateRemainingResults() {
        int maxRemaining = this.maxResults == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.maxResults - this.currentResultCount;
        return maxRemaining >= this.batchLimit ? this.batchLimit : maxRemaining;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    public void closeSelfResources() {
        if (this.currentIterator != null) {
            this.currentIterator.closeSelfResources();
            this.currentIterator = null;
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.closeSelfResources();
            this.connectionResource.release();
        }
        finally {
            this.closed = true;
        }
    }
}

