/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.document.SpaceDocument;
import java.util.Iterator;
import java.util.Map;
import org.openspaces.persistency.cassandra.CassandraConsistencyLevel;
import org.openspaces.persistency.cassandra.datasource.CQLQueryContext;
import org.openspaces.persistency.cassandra.datasource.CassandraTokenRangeAwareDataIterator;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.pool.ConnectionResource;

public class CassandraTokenRangeAwareInitialLoadDataIterator
implements DataIterator<Object> {
    private final SpaceDocumentColumnFamilyMapper mapper;
    private final Map<String, ColumnFamilyMetadata> metadataMap;
    private final Iterator<Map.Entry<String, ColumnFamilyMetadata>> metadata;
    private final ConnectionResource connectionResource;
    private final Map<String, String> initialLoadQueries;
    private final int batchLimit;
    private final CassandraConsistencyLevel readConsistencyLevel;
    private CassandraTokenRangeAwareDataIterator currentIterator;

    public CassandraTokenRangeAwareInitialLoadDataIterator(SpaceDocumentColumnFamilyMapper mapper, Map<String, ColumnFamilyMetadata> metadataMap, ConnectionResource connectionResource, Map<String, String> queries, int batchLimit, CassandraConsistencyLevel readConsistencyLevel) {
        this.mapper = mapper;
        this.batchLimit = batchLimit;
        this.connectionResource = connectionResource;
        this.initialLoadQueries = queries;
        this.readConsistencyLevel = readConsistencyLevel;
        this.metadataMap = metadataMap;
        this.metadata = metadataMap.entrySet().iterator();
        this.currentIterator = this.nextDataIterator();
    }

    public boolean hasNext() {
        while (this.currentIterator != null && !this.currentIterator.hasNext()) {
            this.currentIterator = this.nextDataIterator();
        }
        return this.currentIterator != null;
    }

    public SpaceDocument next() {
        return this.currentIterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove is not supported for this iterator");
    }

    public void close() {
        if (this.currentIterator != null) {
            this.currentIterator.closeSelfResources();
        }
        this.connectionResource.release();
    }

    private CassandraTokenRangeAwareDataIterator nextDataIterator() {
        if (this.metadata.hasNext()) {
            Map.Entry<String, ColumnFamilyMetadata> metadata = this.metadata.next();
            CQLQueryContext queryContext = null;
            if (this.initialLoadQueries != null && this.initialLoadQueries.containsKey(metadata.getKey())) {
                queryContext = new CQLQueryContext(null, this.initialLoadQueries.get(metadata.getKey()), new Object[0]);
            }
            return new CassandraTokenRangeAwareDataIterator(this.mapper, metadata.getValue(), this.connectionResource, queryContext, Integer.MAX_VALUE, this.batchLimit, this.readConsistencyLevel);
        }
        return null;
    }
}

