/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.utils.StringUtils;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientConnectionException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.prettyprint.hector.api.Serializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.persistency.cassandra.CassandraConsistencyLevel;
import org.openspaces.persistency.cassandra.datasource.CQLQueryContext;
import org.openspaces.persistency.cassandra.error.SpaceCassandraQueryExecutionException;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.ColumnMetadata;
import org.openspaces.persistency.cassandra.meta.DynamicColumnMetadata;
import org.openspaces.persistency.cassandra.meta.data.ColumnData;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.types.dynamic.DynamicPropertySerializer;
import org.openspaces.persistency.cassandra.pool.ConnectionResource;

public class CassandraTokenRangeJDBCDataIterator
implements DataIterator<Object> {
    private static final Log logger = LogFactory.getLog(CassandraTokenRangeJDBCDataIterator.class);
    private static final String IDENTIFIER = "((?:[a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*)";
    private static final String OPERATOR = "(?:=|<|>|<=|>=)";
    private static final String COLUMN_NAME_REGEX = "(?:((?:[a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*)\\s*(?:=|<|>|<=|>=)\\s*?)";
    private static final Pattern COLUMN_NAME_PATTERN = Pattern.compile("(?:((?:[a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*)\\s*(?:=|<|>|<=|>=)\\s*?)");
    private final SpaceDocumentColumnFamilyMapper mapper;
    private final ColumnFamilyMetadata columnFamilyMetadata;
    private final int limit;
    private final CassandraConsistencyLevel readConsistencyLevel;
    private final ConnectionResource connectionResource;
    private final PreparedStatement preparedStatement;
    private final ResultSet resultSet;
    private Object currentLastToken;
    private SpaceDocument currentResultInResultSet;
    private int currentTotalCount = 0;

    public CassandraTokenRangeJDBCDataIterator(SpaceDocumentColumnFamilyMapper mapper, ColumnFamilyMetadata columnFamilyMetadata, ConnectionResource connectionResource, CQLQueryContext queryContext, Object lastToken, int limit, CassandraConsistencyLevel readConsistencyLevel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating range data iterator for query: " + queryContext + " for type: " + columnFamilyMetadata.getTypeName() + ", limit=" + limit + ", starting from token(" + (lastToken != null ? lastToken : "FIRST_IN_RING") + ")"));
        }
        this.mapper = mapper;
        this.columnFamilyMetadata = columnFamilyMetadata;
        this.connectionResource = connectionResource;
        this.limit = limit;
        this.readConsistencyLevel = readConsistencyLevel;
        Connection connection = connectionResource.getConnection();
        PreparedStatementData statementData = this.generateSqlQuery(queryContext);
        this.prepareRangeAndLimitStatement(statementData, lastToken, limit);
        try {
            this.preparedStatement = connection.prepareStatement(statementData.query);
            this.setPreparedStatementParameters(statementData);
        }
        catch (SQLSyntaxErrorException e) {
            throw new SpaceCassandraQueryExecutionException("Failed preparing statement " + statementData.query, e);
        }
        catch (SQLException e) {
            connectionResource.closeCurrentConnection();
            throw new SpaceCassandraQueryExecutionException("Failed preparing statement " + statementData.query, e);
        }
        try {
            this.resultSet = this.preparedStatement.executeQuery();
        }
        catch (SQLSyntaxErrorException e) {
            throw new SpaceCassandraQueryExecutionException("Failed executing statement " + statementData.query, e);
        }
        catch (SQLTransientConnectionException e) {
            throw new SpaceCassandraQueryExecutionException("Failed executing statement " + statementData.query, e);
        }
        catch (SQLException e) {
            connectionResource.closeCurrentConnection();
            throw new SpaceCassandraQueryExecutionException("Failed executing statement " + statementData.query, e);
        }
        this.hasNext();
    }

    public boolean hasNext() {
        if (this.currentResultInResultSet != null) {
            return true;
        }
        try {
            this.currentResultInResultSet = this.getNextValidDocument();
            return this.currentResultInResultSet != null;
        }
        catch (SQLException e) {
            throw new SpaceCassandraQueryExecutionException("Failed checking for any remaining entries ", e);
        }
    }

    private SpaceDocument getNextDocument() throws SQLException {
        LinkedList<ColumnData> columns = new LinkedList<ColumnData>();
        Object keyValue = null;
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i);
            Object columnValue = this.resultSet.getObject(i);
            if (this.columnFamilyMetadata.getKeyName().equals(columnName)) {
                keyValue = columnValue;
                if (!(keyValue instanceof ByteBuffer)) continue;
                keyValue = this.columnFamilyMetadata.getKeySerializer().fromByteBuffer((ByteBuffer)keyValue);
                continue;
            }
            ColumnMetadata columnMetadata = this.columnFamilyMetadata.getColumns().get(columnName);
            if (columnMetadata == null) {
                columnMetadata = new DynamicColumnMetadata(columnName, this.mapper.getTypeNodeIntrospector().getDynamicPropertyValueSerializer());
            }
            if (columnValue instanceof ByteBuffer) {
                columnValue = columnMetadata.getSerializer().fromByteBuffer((ByteBuffer)columnValue);
            }
            columns.add(new ColumnData(columnValue, columnMetadata));
        }
        ColumnFamilyRow row = new ColumnFamilyRow(this.columnFamilyMetadata, keyValue, ColumnFamilyRow.ColumnFamilyRowType.Read);
        for (ColumnData columnData : columns) {
            row.addColumnData(columnData);
        }
        return this.mapper.toDocument(row);
    }

    private SpaceDocument getNextValidDocument() throws SQLException {
        while (this.resultSet.next()) {
            Object currentTokenValue;
            ++this.currentTotalCount;
            SpaceDocument document = this.getNextDocument();
            this.currentLastToken = currentTokenValue = document.getProperty(this.columnFamilyMetadata.getKeyName());
            if (document.getProperties().size() <= 1) continue;
            return document;
        }
        return null;
    }

    public SpaceDocument next() {
        SpaceDocument result;
        if (this.currentResultInResultSet != null) {
            result = this.currentResultInResultSet;
            this.currentResultInResultSet = null;
        } else {
            try {
                result = this.getNextValidDocument();
            }
            catch (SQLException e) {
                throw new SpaceCassandraQueryExecutionException("Failed retrieving next entry", e);
            }
        }
        return result;
    }

    private PreparedStatementData generateSqlQuery(CQLQueryContext queryContext) {
        PreparedStatementData result = new PreparedStatementData();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("SELECT * FROM ").append(CassandraTokenRangeJDBCDataIterator.quote(this.columnFamilyMetadata.getColumnFamilyName()));
        sqlQuery.append(" USING CONSISTENCY ").append(this.readConsistencyLevel.name());
        if (queryContext == null) {
            result.query = sqlQuery.toString();
            return result;
        }
        if (queryContext.hasProperties() && !queryContext.getProperties().isEmpty()) {
            int propertyIndex = 1;
            for (Map.Entry<String, Object> entry : queryContext.getProperties().entrySet()) {
                if (entry.getValue() == null) continue;
                sqlQuery.append(" ").append(propertyIndex == 1 ? "WHERE" : "AND").append(" ").append(CassandraTokenRangeJDBCDataIterator.quote(entry.getKey())).append(" = ? ");
                result.propertyValues.add(entry.getValue());
                Serializer<Object> serailizer = this.getSerializer(entry.getKey());
                result.serializers.add(serailizer);
                ++propertyIndex;
            }
        } else if (StringUtils.hasText((String)queryContext.getSqlQuery())) {
            String selectSqlQuery = queryContext.getSqlQuery();
            Matcher columnNamesMatcher = COLUMN_NAME_PATTERN.matcher(selectSqlQuery);
            while (columnNamesMatcher.find()) {
                String columnName = columnNamesMatcher.group(1);
                Serializer<Object> serailizer = this.getSerializer(columnName);
                result.serializers.add(serailizer);
                selectSqlQuery = selectSqlQuery.replace(columnName, CassandraTokenRangeJDBCDataIterator.quote(columnName));
            }
            sqlQuery.append(" WHERE ").append(selectSqlQuery);
            for (int i = 0; i < queryContext.getParameters().length; ++i) {
                result.propertyValues.add(queryContext.getParameters()[i]);
            }
        }
        result.query = sqlQuery.toString();
        return result;
    }

    private Serializer<Object> getSerializer(String columnName) {
        Object serailizer = this.columnFamilyMetadata.getKeyName().equals(columnName) ? this.columnFamilyMetadata.getKeySerializer() : (this.columnFamilyMetadata.getColumns().containsKey(columnName) ? this.columnFamilyMetadata.getColumns().get(columnName).getSerializer() : DynamicPropertySerializer.get());
        return serailizer;
    }

    private void prepareRangeAndLimitStatement(PreparedStatementData statementData, Object lastToken, long limit) {
        StringBuilder newQuery = new StringBuilder(statementData.query);
        if (lastToken != null) {
            if (statementData.query.toUpperCase().contains(" WHERE ")) {
                newQuery.append(" AND ");
            } else {
                newQuery.append(" WHERE ");
            }
            newQuery.append(CassandraTokenRangeJDBCDataIterator.quote(this.columnFamilyMetadata.getKeyName())).append(" > ? ");
            statementData.propertyValues.add(lastToken);
            statementData.serializers.add(this.getSerializer(this.columnFamilyMetadata.getKeyName()));
        }
        newQuery.append(" LIMIT ").append(limit);
        statementData.query = newQuery.toString();
    }

    private void setPreparedStatementParameters(PreparedStatementData statementData) throws SQLException {
        for (int i = 0; i < statementData.propertyValues.size(); ++i) {
            int index = i + 1;
            Object propertyValue = statementData.propertyValues.get(i);
            Serializer<Object> serializer = statementData.serializers.get(i);
            byte[] serializedPropertyValue = serializer.toBytes(propertyValue);
            this.preparedStatement.setBytes(index, serializedPropertyValue);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public void closeSelfResources() {
        try {
            if (!this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            if (!this.preparedStatement.isClosed()) {
                this.preparedStatement.close();
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"Failed closing result set or prepared statement", (Throwable)e);
        }
    }

    public void close() {
        this.closeSelfResources();
        this.connectionResource.release();
    }

    public Object getLastToken() {
        return this.currentLastToken;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCurrentTotalCount() {
        return this.currentTotalCount;
    }

    private static String quote(String s) {
        return s == null ? null : "'" + s + "'";
    }

    private static class PreparedStatementData {
        List<Serializer<Object>> serializers = new ArrayList<Serializer<Object>>();
        List<Object> propertyValues = new ArrayList<Object>();
        String query;

        private PreparedStatementData() {
        }
    }
}

