/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.datasource;

import com.gigaspaces.document.SpaceDocument;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyRowMapper;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.ColumnMetadata;
import org.openspaces.persistency.cassandra.meta.DynamicColumnMetadata;
import org.openspaces.persistency.cassandra.meta.data.ColumnData;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;

public class SpaceDocumentMapper
implements ColumnFamilyRowMapper<Object, String, SpaceDocument> {
    private final SpaceDocumentColumnFamilyMapper mapper;
    private final ColumnFamilyMetadata metadata;

    public SpaceDocumentMapper(ColumnFamilyMetadata metadata, SpaceDocumentColumnFamilyMapper mapper) {
        this.mapper = mapper;
        this.metadata = metadata;
    }

    public SpaceDocument mapRow(ColumnFamilyResult<Object, String> rs) {
        ColumnFamilyRow row = new ColumnFamilyRow(this.metadata, rs.getKey(), ColumnFamilyRow.ColumnFamilyRowType.Read);
        for (String columnName : rs.getColumnNames()) {
            ColumnMetadata columnMetadata = this.metadata.getColumns().get(columnName);
            if (columnMetadata == null) {
                columnMetadata = new DynamicColumnMetadata(columnName, this.mapper.getTypeNodeIntrospector().getDynamicPropertyValueSerializer());
            }
            Object columnValue = columnMetadata.getSerializer().fromByteBuffer(rs.getColumn((Object)columnName).getValueBytes());
            row.addColumnData(new ColumnData(columnValue, columnMetadata));
        }
        return this.mapper.toDocument(row);
    }
}

