/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta;

import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.prettyprint.hector.api.Serializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.persistency.cassandra.meta.TypedColumnMetadata;
import org.openspaces.persistency.cassandra.meta.conversion.ColumnFamilyNameConverter;
import org.openspaces.persistency.cassandra.meta.mapping.node.TopLevelTypeNode;
import org.openspaces.persistency.cassandra.meta.types.SerializerProvider;
import org.openspaces.persistency.support.SpaceTypeDescriptorContainer;

public class ColumnFamilyMetadata
implements Externalizable {
    private static final Log logger = LogFactory.getLog(ColumnFamilyMetadata.class);
    private static final long serialVersionUID = 1L;
    private static final byte SERIAL_VER = -128;
    private final transient Map<String, TypedColumnMetadata> columns = new HashMap<String, TypedColumnMetadata>();
    private final transient Set<String> indexes = new HashSet<String>();
    private transient Serializer<?> keySerializer;
    private transient String typeName;
    private transient String keyName;
    private transient Class<?> keyType;
    private SpaceTypeDescriptorContainer typeDescriptorData;
    private TopLevelTypeNode topLevelTypeNode;
    private String columnFamilyName;

    public ColumnFamilyMetadata() {
    }

    public ColumnFamilyMetadata(TopLevelTypeNode topLevelTypeNode, Set<String> initialIndexes, ColumnFamilyNameConverter columnFamilyNameConverter, SpaceTypeDescriptorContainer typeDescriptorData) {
        this.topLevelTypeNode = topLevelTypeNode;
        this.typeDescriptorData = typeDescriptorData;
        if (initialIndexes != null) {
            this.indexes.addAll(initialIndexes);
        }
        this.initFieldsFromTopLevelTypeNode();
        this.columnFamilyName = columnFamilyNameConverter.toColumnFamilyName(this.typeName);
    }

    private void initFieldsFromTopLevelTypeNode() {
        this.typeName = this.topLevelTypeNode.getTypeName();
        this.keyName = this.topLevelTypeNode.getKeyName();
        this.keyType = this.topLevelTypeNode.getKeyType();
        this.keySerializer = SerializerProvider.getSerializer(this.keyType);
        this.columns.putAll(this.topLevelTypeNode.getAllTypedColumnMetadataChildren());
    }

    public SpaceTypeDescriptorContainer getTypeDescriptorData() {
        return this.typeDescriptorData;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public Serializer<?> getKeySerializer() {
        return this.keySerializer;
    }

    public Map<String, TypedColumnMetadata> getColumns() {
        return this.columns;
    }

    public TopLevelTypeNode getTopLevelTypeNode() {
        return this.topLevelTypeNode;
    }

    public Set<String> getIndexes() {
        return this.indexes;
    }

    public void setFixedPropertySerializerForTypedColumn(Serializer<?> serializer) {
        for (TypedColumnMetadata typeColumnMetadata : this.columns.values()) {
            if (SerializerProvider.isCommonJavaType(typeColumnMetadata.getType())) continue;
            typeColumnMetadata.setSerializer(serializer);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(-128);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.typeDescriptorData);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.topLevelTypeNode);
        IOUtils.writeString((ObjectOutput)out, (String)this.columnFamilyName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.typeDescriptorData = (SpaceTypeDescriptorContainer)IOUtils.readObject((ObjectInput)in);
        this.topLevelTypeNode = (TopLevelTypeNode)IOUtils.readObject((ObjectInput)in);
        this.columnFamilyName = IOUtils.readString((ObjectInput)in);
        this.initFieldsFromTopLevelTypeNode();
    }

    public String toString() {
        return "ColumnFamilyMetadata [  typeName=" + this.typeName + ", columnFamilyName=" + this.columnFamilyName + ", keyName=" + this.keyName + ", keyType=" + this.keyType + ", indexes=" + this.indexes + ", " + (logger.isTraceEnabled() ? "columns=" + this.columns.values() : "columnsSize=" + this.columns.size()) + " ]";
    }
}

