/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta;

import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import me.prettyprint.hector.api.Serializer;
import org.openspaces.persistency.cassandra.meta.AbstractColumnMetadata;
import org.openspaces.persistency.cassandra.meta.mapping.node.ExternalizableTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeContext;
import org.openspaces.persistency.cassandra.meta.types.PrimitiveClassUtils;
import org.openspaces.persistency.cassandra.meta.types.SerializerProvider;

public class TypedColumnMetadata
extends AbstractColumnMetadata
implements ExternalizableTypeNode {
    private static final long serialVersionUID = 1L;
    public static final byte SERIAL_VER = -128;
    private transient Serializer<?> serializer;
    private String fullName;
    private String name;
    private Class<?> type;

    public TypedColumnMetadata() {
    }

    public TypedColumnMetadata(String parentFullName, String name, Class<?> type, TypeNodeContext context, Serializer<Object> fixedPropertyValueSerializer) {
        this.serializer = fixedPropertyValueSerializer;
        this.fullName = (parentFullName != null ? parentFullName + "." : "") + name;
        this.name = name;
        this.type = type;
        this.initFields();
    }

    private void initFields() {
        if (this.serializer == null) {
            this.serializer = SerializerProvider.getSerializer(this.type);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public <T> Serializer<T> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(-128);
        IOUtils.writeString((ObjectOutput)out, (String)this.name);
        IOUtils.writeString((ObjectOutput)out, (String)this.fullName);
        IOUtils.writeString((ObjectOutput)out, (String)this.type.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.name = IOUtils.readString((ObjectInput)in);
        this.fullName = IOUtils.readString((ObjectInput)in);
        String typeName = IOUtils.readString((ObjectInput)in);
        this.type = PrimitiveClassUtils.isPrimitive(typeName) ? PrimitiveClassUtils.getPrimitive(typeName) : Class.forName(typeName, false, Thread.currentThread().getContextClassLoader());
        this.initFields();
    }

    public String toString() {
        return "TypedColumnMetadata [fullName=" + this.fullName + ", type=" + this.type + "]";
    }
}

