/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.conversion;

import com.gigaspaces.security.encoding.md5.Md5Encrypter;
import org.openspaces.persistency.cassandra.meta.conversion.ColumnFamilyNameConverter;

public class DefaultColumnFamilyNameConverter
implements ColumnFamilyNameConverter {
    private static final int MAX_CF_NAME_LENGTH = 48;
    private static final int NUMBER_OF_MD5_CHARS_SUFFIX = 6;
    private final Md5Encrypter encrypter = new Md5Encrypter();

    @Override
    public String toColumnFamilyName(String typeName) {
        if (typeName == null) {
            return null;
        }
        String typeNameMD5 = this.encrypter.encrypt(typeName);
        String typeNameMD5Suffix = typeNameMD5.substring(0, 6);
        String underScoredTypeName = typeName.replace('.', '_').replace('$', '_');
        String[] typeNameSplit = underScoredTypeName.split("_");
        String simpleTypeName = typeNameSplit[typeNameSplit.length - 1];
        String columnFamilyName = underScoredTypeName.length() <= 48 ? underScoredTypeName : (simpleTypeName.length() + 6 <= 48 ? simpleTypeName + typeNameMD5Suffix : simpleTypeName.substring(0, 42) + typeNameMD5Suffix);
        return columnFamilyName;
    }
}

